/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixFactory;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.IEigenSystem;

public class JohansenCointegration {
    private final Spec spec;
    private final ECDet ecdet;
    private final int k;
    private final int season;
    private FastMatrix X;
    private FastMatrix Z;
    private FastMatrix Z0;
    private FastMatrix Z2;
    private FastMatrix Z1;
    private FastMatrix D;
    private FastMatrix Ds;
    private FastMatrix T;
    private IntList rows;
    private double[] vp;
    private FastMatrix V;
    private static final double[] CVNONE = new double[]{6.5, 12.91, 18.9, 24.78, 30.84, 36.25, 42.06, 48.43, 54.01, 59.0, 65.07, 8.18, 14.9, 21.07, 27.14, 33.32, 39.43, 44.91, 51.07, 57.0, 62.42, 68.27, 11.65, 19.19, 25.75, 32.14, 38.78, 44.59, 51.3, 57.07, 63.37, 68.61, 74.36, 6.5, 15.66, 28.71, 45.23, 66.49, 85.18, 118.99, 151.38, 186.54, 226.34, 269.53, 8.18, 17.95, 31.52, 48.28, 70.6, 90.39, 124.25, 157.11, 192.84, 232.49, 277.39, 11.65, 23.52, 37.22, 55.43, 78.87, 104.2, 136.06, 168.92, 204.79, 246.27, 292.65};
    private static final double[] CVCONST = new double[]{7.52, 13.75, 19.77, 25.56, 31.66, 37.45, 43.25, 48.91, 54.35, 60.25, 66.02, 9.24, 15.67, 22.0, 28.14, 34.4, 40.3, 46.45, 52.0, 57.42, 63.57, 69.74, 12.97, 20.2, 26.81, 33.24, 39.79, 46.82, 51.91, 57.95, 63.71, 69.94, 76.63, 7.52, 17.85, 32.0, 49.65, 71.86, 97.18, 126.58, 159.48, 196.37, 236.54, 282.45, 9.24, 19.96, 34.91, 53.12, 76.07, 102.14, 131.7, 165.58, 202.92, 244.15, 291.4, 12.97, 24.6, 41.07, 60.16, 84.45, 111.01, 143.09, 177.2, 215.74, 257.68, 307.64};
    private static final double[] CVTREND = new double[]{10.49, 16.85, 23.11, 29.12, 34.75, 40.91, 46.32, 52.16, 57.87, 63.18, 69.26, 12.25, 18.96, 25.54, 31.46, 37.52, 43.97, 49.42, 55.5, 61.29, 66.23, 72.72, 16.26, 23.65, 30.34, 36.65, 42.36, 49.51, 54.71, 62.46, 67.88, 73.73, 79.23, 10.49, 22.76, 39.06, 59.14, 83.2, 110.42, 141.01, 176.67, 215.17, 256.72, 303.13, 12.25, 25.32, 42.44, 62.99, 87.31, 114.9, 146.76, 182.82, 222.21, 263.42, 310.81, 16.26, 30.45, 48.45, 70.05, 96.58, 124.75, 158.49, 196.08, 234.41, 279.07, 327.45};

    public static Builder builder() {
        return new Builder();
    }

    private JohansenCointegration(Builder builder) {
        this.spec = builder.spec;
        this.ecdet = builder.ecdet;
        this.k = builder.k;
        this.season = builder.season;
    }

    public void process(FastMatrix x, FastMatrix dummies) {
        int s;
        this.clear();
        int p = x.getColumnsCount();
        int n = x.getRowsCount();
        int n2 = s = this.season > 0 ? this.season - 1 : 0;
        if (n * p < p + s * p + this.k * p * p + p * (p + 1) / 2) {
            throw new StatException("Insufficient degrees of freedom");
        }
        this.rows = new IntList();
        this.X = MatrixFactory.cleanRows(x, z -> Double.isFinite(z), this.rows);
        if (this.rows.size() == n) {
            this.rows = null;
        }
        this.D = MatrixFactory.selectRows(dummies, this.rows);
        this.buildDet(n);
        this.buildZ();
        int nz = this.Z0.getRowsCount();
        FastMatrix M22 = SymmetricMatrix.XtX(this.Z2);
        FastMatrix M20 = GeneralMatrix.AtB(this.Z2, this.Z0);
        FastMatrix M21 = GeneralMatrix.AtB(this.Z2, this.Z1);
        FastMatrix M22inv = SymmetricMatrix.inverse(M22);
        FastMatrix R0 = this.Z0.minus(GeneralMatrix.AB(this.Z2, GeneralMatrix.AB(M22inv, M20)));
        FastMatrix R1 = this.Z1.minus(GeneralMatrix.AB(this.Z2, GeneralMatrix.AB(M22inv, M21)));
        FastMatrix S00 = SymmetricMatrix.XtX(R0);
        FastMatrix S11 = SymmetricMatrix.XtX(R1);
        FastMatrix S01 = GeneralMatrix.AtB(R0, R1);
        S00.div(nz);
        S11.div(nz);
        S01.div(nz);
        FastMatrix L0 = S00;
        SymmetricMatrix.lcholesky(L0);
        FastMatrix K1 = S01;
        LowerTriangularMatrix.solveLX(L0, K1);
        FastMatrix L1 = S11;
        SymmetricMatrix.lcholesky(L1);
        LowerTriangularMatrix.solveXLt(L1, K1);
        FastMatrix K = SymmetricMatrix.XtX(K1);
        IEigenSystem eig = EigenSystem.create(K, true);
        eig.setComputingEigenVectors(true);
        eig.compute();
        Complex[] eigenValues = eig.getEigenValues();
        FastMatrix E = eig.getEigenVectors();
        LowerTriangularMatrix.solveLX(L1, E);
        this.V = FastMatrix.make(E.getRowsCount(), E.getColumnsCount());
        this.vp = new double[eigenValues.length];
        for (int i = 0; i < this.vp.length; ++i) {
            int jmax = 0;
            double vmax = 0.0;
            for (int j = 0; j < this.vp.length; ++j) {
                if (eigenValues[j] == null || !(eigenValues[j].getRe() > vmax)) continue;
                vmax = eigenValues[j].getRe();
                jmax = j;
            }
            this.vp[i] = vmax;
            this.V.column(i).copy(E.column(jmax));
            eigenValues[jmax] = null;
        }
    }

    public double traceCriticalValue(int eps) {
        return this.cv(this.Z0.getColumnsCount(), eps, 1);
    }

    public double maxCriticalValue(int eps) {
        return this.cv(this.Z0.getColumnsCount(), eps, 0);
    }

    public double traceTest(int k) {
        if (this.vp == null) {
            return Double.NaN;
        }
        int nz = this.Z0.getRowsCount();
        double t = 0.0;
        for (int j = k; j < this.vp.length; ++j) {
            t += Math.log(1.0 - this.vp[j]);
        }
        return -t * (double)nz;
    }

    public double maxTest(int k) {
        if (this.vp == null) {
            return Double.NaN;
        }
        int nz = this.Z0.getRowsCount();
        return (double)(-nz) * Math.log(1.0 - this.vp[k]);
    }

    private int[] order(int[] p) {
        int[] o = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            o[p[i]] = i;
        }
        return o;
    }

    private void buildDet(int n) {
        if (this.season > 1) {
            this.Ds = FastMatrix.make(n, this.season - 1);
            this.Ds.set(1.0 / (double)this.season);
            for (int i = 0; i < this.Ds.getColumnsCount(); ++i) {
                this.Ds.column(i).extract(i, -1, this.season).add(1.0);
            }
            this.Ds = MatrixFactory.selectRows(this.Ds, this.rows);
        }
        if (this.ecdet == ECDet.trend) {
            if (this.rows == null) {
                this.T = FastMatrix.make(n, 1);
                this.T.set((r, c) -> r + 1);
            } else {
                this.T = FastMatrix.make(this.rows.size(), 1);
                this.T.set((r, c) -> this.rows.get(r) + 1);
            }
        }
    }

    private void buildZ() {
        int p = this.X.getColumnsCount();
        this.Z = MatrixFactory.embed(MatrixFactory.delta(this.X, 1, 1), this.k);
        int nz = this.Z.getRowsCount();
        this.Z0 = this.Z.extract(0, nz, 0, p);
        Matrix one = this.one(nz);
        FastMatrix D1 = this.D == null ? null : this.D.extract(this.k, nz, 0, this.D.getColumnsCount());
        FastMatrix Ds1 = this.Ds == null ? null : this.Ds.extract(this.k, nz, 0, this.Ds.getColumnsCount());
        FastMatrix T1 = this.T == null ? null : this.T.extract(this.k, nz, 0, 1);
        switch (this.ecdet.ordinal()) {
            case 1: {
                this.Z1 = this.spec == Spec.longrun ? MatrixFactory.columnBind(new Matrix[]{this.X.extract(0, nz, 0, p), one}) : MatrixFactory.columnBind(new Matrix[]{this.X.extract(this.k - 1, nz, 0, p), one});
                this.Z2 = MatrixFactory.columnBind(new Matrix[]{D1, Ds1, this.Z.extract(0, nz, p, this.Z.getColumnsCount() - p)});
                break;
            }
            case 2: {
                this.Z1 = this.spec == Spec.longrun ? MatrixFactory.columnBind(new Matrix[]{this.X.extract(0, nz, 0, p), T1}) : MatrixFactory.columnBind(new Matrix[]{this.X.extract(this.k - 1, nz, 0, p), T1});
                this.Z2 = MatrixFactory.columnBind(new Matrix[]{one, D1, Ds1, this.Z.extract(0, nz, p, this.Z.getColumnsCount() - p)});
                break;
            }
            case 0: {
                this.Z1 = this.spec == Spec.longrun ? this.X.extract(0, nz, 0, p) : this.X.extract(this.k - 1, nz, 0, p);
                this.Z2 = MatrixFactory.columnBind(new Matrix[]{one, D1, Ds1, this.Z.extract(0, nz, p, this.Z.getColumnsCount() - p)});
            }
        }
    }

    private Matrix one(int n) {
        FastMatrix one = FastMatrix.make(n, 1);
        one.set(1.0);
        return one;
    }

    private void clear() {
        this.T = null;
        this.Ds = null;
        this.D = null;
        this.Z1 = null;
        this.Z2 = null;
        this.Z0 = null;
        this.Z = null;
        this.X = null;
        this.rows = null;
    }

    private double cv(int a, int b, int c) {
        switch (this.ecdet.ordinal()) {
            case 1: {
                return JohansenCointegration.cvconst(a, b, c);
            }
            case 2: {
                return JohansenCointegration.cvtrend(a, b, c);
            }
        }
        return JohansenCointegration.cvnone(a, b, c);
    }

    private static double cvnone(int a, int b, int c) {
        if (a >= 11 || b >= 3 || c >= 2) {
            return Double.NaN;
        }
        int idx = a + 11 * b + 33 * c;
        return CVNONE[idx];
    }

    private static double cvconst(int a, int b, int c) {
        if (a >= 11 || b >= 3 || c >= 2) {
            return Double.NaN;
        }
        int idx = a + 11 * b + 33 * c;
        return CVCONST[idx];
    }

    private static double cvtrend(int a, int b, int c) {
        if (a >= 11 || b >= 3 || c >= 2) {
            return Double.NaN;
        }
        int idx = a + 11 * b + 33 * c;
        return CVTREND[idx];
    }

    public static class Builder {
        private Spec spec = Spec.transitory;
        private ECDet ecdet = ECDet.none;
        private int k = 2;
        private int season = 0;

        public Builder season(int season) {
            this.season = season;
            return this;
        }

        public Builder lag(int k) {
            this.k = k;
            return this;
        }

        public Builder errorCorrectionModel(ECDet det) {
            this.ecdet = det;
            return this;
        }

        public JohansenCointegration build() {
            return new JohansenCointegration(this);
        }
    }

    public static enum Spec {
        longrun,
        transitory;

    }

    public static enum ECDet {
        none,
        cnt,
        trend;

    }
}

