% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{periodic_dummies}
\alias{periodic_dummies}
\alias{periodic_contrasts}
\title{Periodic dummies and contrasts}
\usage{
periodic_dummies(frequency, start, length, s)

periodic_contrasts(frequency, start, length, s)
}
\arguments{
\item{frequency}{Frequency of the series, number of periods per year
(12, 4, 3, 2...)}

\item{start, length}{First date (array with the first year and the first
period, for instance \code{c(1980, 1)}) and number of periods of the output
variables. Can also be provided with the \code{s} argument}

\item{s}{time series used to get the dates for the trading days variables.
If supplied the parameters \code{frequency}, \code{start} and \code{length} are ignored.}
}
\value{
a \code{mts} object with \code{frequency} column
}
\description{
Periodic dummies and contrasts
}
\details{
The function \code{periodic_dummies()} creates as many time series as types of periods in a year (4 or 12)
with the value one only for one given type of period (ex Q1)
The \code{periodic_contrasts()} function is based on periodic_dummies but adds -1 to the period preceding a 1.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# periodic dummies for a quarterly series
p <- periodic_dummies(4, c(2000, 1), 60)
# periodic contrasts for a quarterly series
q <- periodic_contrasts(4, c(2000, 1), 60)
q[1:9, ]
\dontshow{\}) # examplesIf}
}
