% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_seasonality.R
\name{seasonality_combined}
\alias{seasonality_combined}
\title{"X12" Test On Seasonality}
\usage{
seasonality_combined(
  data,
  period = NA,
  firstperiod = cycle(data)[1],
  mul = TRUE
)
}
\arguments{
\item{data}{the input data.}

\item{period}{Tested periodicity. Can be missing if the input is a time series}

\item{firstperiod}{Position in a cycle of the first obs.
For example, for a monthly, \code{firstperiod = 1} means January.
If \code{data} is not a \code{"ts"} object, \code{firstperiod = 1} by default.}

\item{mul}{boolean indicating if the seasonal decomposition is multiplicative (\code{mul = TRUE}) or additive (\code{mul = FALSE}).}
}
\value{
a \code{list} with several seasonnality tests (kruskalwallis, stable and evolutive)
}
\description{
"X12" Test On Seasonality
}
\details{
Combined test on the presence of identifiable seasonality (see Ladiray and Quenneville, 1999).
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
s <- do_stationary(log(ABS$X0.2.09.10.M))$ddata
seasonality_combined(s)
seasonality_combined(random_t(2, 1000), 7)
\dontshow{\}) # examplesIf}
}
