% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_td.R
\name{td_f}
\alias{td_f}
\title{Residual Trading Days Test}
\usage{
td_f(
  s,
  model = c("D1", "DY", "DYD1", "WN", "AIRLINE", "R011", "R100"),
  nyears = 0
)
}
\arguments{
\item{s}{a \code{ts} object that corresponds to the input time series to
test.}

\item{model}{the model to use for the residuals. See details.}

\item{nyears}{\code{integer} that corresponds to the length of the sub
series, starting from the end of the series, to be used for the test: in
number of periods (positive value) or years (negative values).
By default (\code{nyears = 0}), the entire sample is used.}
}
\value{
a \code{JD3_TEST} object with value, p-value and information about the distribution
}
\description{
Residual Trading Days Test
}
\details{
The function performs a residual seasonality test that is a joint F-Test on
the coefficients of trading days regressors. Several specifications can be
used on the model:
\itemize{
\item \code{model = "WN"} the following model is used:
\deqn{
y_t - \bar y =\beta TD_t +  \varepsilon_t
}
\item \code{model = "D1"} (the default) the following model is used:
\deqn{
\Delta y_t - \overline{\Delta y} =\beta \Delta TD_t +  \varepsilon_t
}
\item \code{model = "DY"} the following model is used:
\deqn{
\Delta_s y_t - \overline{\Delta_s y} =\beta \Delta_s TD_t +  \varepsilon_t
}
\item \code{model = "DYD1"} the following model is used:
\deqn{
\Delta_s\Delta y_t - \overline{\Delta_s \Delta y} =\beta \Delta_s \Delta TD_t + \varepsilon_t
}
\item \code{model = "AIRLINE"} the following model is used:
\deqn{
y_t =\beta TD_t +  \varepsilon_t \text{ with }\varepsilon_t \sim ARIMA(0,1,1)(0,1,1)
}
\item \code{model = "R011"} the following model is used:
\deqn{
y_t =\beta TD_t +  \varepsilon_t \text{ with }\varepsilon_t \sim ARIMA(0,1,1)
}
\item \code{model = "R100"} the following model is used:
\deqn{
y_t =\alpha_0 + \alpha_1 y_{t-1} + \beta TD_t +  \varepsilon_t
}
}
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
td_f(ABS$X0.2.09.10.M)
\dontshow{\}) # examplesIf}
}
