/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter;

import java.util.HashMap;
import java.util.Map;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.HendersonFilters;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MusgraveFilterFactory {
    private static final Map<Key, FiniteFilter[]> FILTERSTORE = new HashMap<Key, FiniteFilter[]>();
    private static final Polynomial X11_H1 = Polynomial.valueOf((double)-0.073, (double[])new double[]{0.294, 0.522, 0.257});
    private static final Polynomial X11_H0 = Polynomial.valueOf((double)-0.073, (double[])new double[]{0.403, 0.67});

    private static Polynomial computeCoefficients(double[] h, double D, int M) {
        double[] c = new double[M];
        int N = h.length;
        int i = 0;
        while (i < M) {
            c[i] = h[i];
            double p1 = 0.0;
            double p2 = 0.0;
            for (int j = M; j < N; ++j) {
                p1 += h[j];
                p2 += h[j] * ((double)(j + 1) - (double)(M + 1) / 2.0);
            }
            int n = i++;
            c[n] = c[n] + ((p1 /= (double)M) + (p2 *= ((double)(i + 1) - (double)(M + 1) / 2.0) * D / (1.0 + (double)(M * (M - 1) * (M + 1)) * D * 0.08333333333333333)));
        }
        return Polynomial.of((double[])c);
    }

    public static double findR(int length, int frequency) {
        if (frequency == 4) {
            return length <= 5 ? 0.001 : 4.5;
        }
        if (frequency == 2) {
            return 0.001;
        }
        if (length <= 9) {
            return 1.0;
        }
        if (length <= 13) {
            return 3.5;
        }
        return 4.5;
    }

    public static FiniteFilter[] makeFilters(IFiniteFilter filter, double ic) {
        double D = 4.0 / (Math.PI * ic * ic);
        int len = filter.getUpperBound();
        if (len <= 0) {
            return null;
        }
        FiniteFilter[] filters = new FiniteFilter[len];
        double[] h = filter.weightsToArray();
        for (int i = 1; i <= len; ++i) {
            Polynomial w = MusgraveFilterFactory.computeCoefficients(h, D, h.length - i);
            filters[i - 1] = new FiniteFilter(w, filter.getLowerBound());
        }
        return filters;
    }

    public static synchronized IFiniteFilter[] makeFiltersForHenderson(int len, int freq) {
        double r = MusgraveFilterFactory.findR(len, freq);
        double D = 4.0 / (Math.PI * r * r);
        Key key = new Key(len, D);
        FiniteFilter[] filters = FILTERSTORE.get(key);
        if (filters == null) {
            filters = new FiniteFilter[len / 2];
            double[] h = HendersonFilters.ofLength((int)len).weightsToArray();
            int l2 = len / 2;
            for (int i = 1; i <= l2; ++i) {
                Polynomial w = MusgraveFilterFactory.computeCoefficients(h, D, len - i);
                filters[i - 1] = new FiniteFilter(w, -l2);
            }
            FILTERSTORE.put(key, filters);
        }
        return (IFiniteFilter[])filters.clone();
    }

    public static FiniteFilter[] makeX11Filters() {
        return new FiniteFilter[]{new FiniteFilter(X11_H1, -2), new FiniteFilter(X11_H0, -2)};
    }

    private static final class Key {
        private final int length;
        private final double D;

        @Generated
        public Key(int length, double D) {
            this.length = length;
            this.D = D;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public double getD() {
            return this.D;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            return Double.compare(this.getD(), other.getD()) == 0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            long $D = Double.doubleToLongBits(this.getD());
            result = result * 59 + (int)($D >>> 32 ^ $D);
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "MusgraveFilterFactory.Key(length=" + this.getLength() + ", D=" + this.getD() + ")";
        }
    }
}

