% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{write.ss.prm}
\alias{write.ss.prm}
\title{Write the SaTScan parameter file}
\usage{
write.ss.prm(location, filename, matchout = TRUE)
}
\arguments{
\item{location}{A directory location, excluding the trailing "/".}

\item{filename}{The name of the file to be written to the OS;
The extension ".prm" will be appended.}

\item{matchout}{If false, the ResultsFile parameter will not
be touched; note that this will likely result in undesirable
performance from calls to \code{satcan()} using the parameter file.
If true, the ResultsFile is reset to share the filename given here.}
}
\value{
Nothing. (Invisibly.)  Side effect is to write a file
in the OS.
}
\description{
Writes the current set of SaTScan parameters to a
specified location in the OS.
}
\details{
The current SaTScan options can be reset or modified
\code{ss.options()} and/or \code{ss.options.extra()}.  Once
they are set as desired, they can be written to the OS
using this function.
}
\examples{
\dontrun{
## Would write the current ss.options() to c:/temp/NYCfever.prm
write.ss.prm("c:/tmp","NYCfever")
}



}
\seealso{
\code{\link{ss.options}}, \code{\link{ss.options.extra}}
}
