% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pmodel_f_bysite.R
\name{run_pmodel_f_bysite}
\alias{run_pmodel_f_bysite}
\title{Run P-model (time series)}
\usage{
run_pmodel_f_bysite(
  sitename,
  params_siml,
  site_info,
  forcing,
  params_modl,
  makecheck = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{sitename}{Site name.}

\item{params_siml}{Simulation parameters.}

\item{site_info}{Site meta info in a data.frame.}

\item{forcing}{A data frame of forcing climate data, used as input.}

\item{params_modl}{A named list of free (calibratable) model parameters. See \code{\link{runread_pmodel_f}}}

\item{makecheck}{A logical specifying whether checks are performed 
to verify forcings and model parameters. \code{TRUE} by default.}

\item{verbose}{A logical specifying whether to print warnings.
Defaults to \code{TRUE}.

For further specifications of above inputs and examples see \code{\link{p_model_drivers}} or \code{\link{p_model_drivers_vcmax25}}}
}
\value{
Model output is provided as a tidy dataframe, with columns:
\describe{
  \item{\code{date}}{Date of the observation in YYYY-MM-DD format.}
  \item{\code{year_dec}}{Decimal representation of year and day of the year
     (for example, 2007.000 corresponds to 2007-01-01 and 2007.003 to 2007-01-02.}
  \item{\code{fapar}}{Fraction of photosynthetic active radiation (fAPAR), taking
     values between 0 and 1.}
  \item{\code{gpp}}{Gross Primary Productivity (GPP) for each time stamp 
      (in gC m\eqn{^{-2}} d\eqn{^{-1}}).}
  \item{\code{aet}}{Actual evapotranspiration (AET), calculated by SPLASH following Priestly-Taylor (in mm d\eqn{^{-1}}).}
  \item{\code{le}}{Latent heat flux (in J m\eqn{^{-2}} d\eqn{^{-1}}).}
  \item{\code{pet}}{Potential evapotranspiration (PET), calculated by SPLASH following Priestly-Taylor (in mm d\eqn{^{-1}}).}
  \item{\code{vcmax}}{Maximum rate of RuBisCO carboxylation 
      (Vcmax) (in mol C m\eqn{^{-2}} s\eqn{^{-1}}).}
  \item{\code{jmax}}{Maximum rate of electron transport for RuBP regeneration
      (in mol CO\eqn{_2} m\eqn{^{-2}} s\eqn{^{-1}}).}
  \item{\code{vcmax25}}{Maximum rate of carboxylation (Vcmax), 
      normalised to 25\eqn{^o}C (in mol C m\eqn{^{-2}} s\eqn{^{-1}}).} 
  \item{\code{jmax25}}{Maximum rate of electron transport, normalised to 
      25\eqn{^o}C (in mol C m\eqn{^{-2}} s\eqn{^{-1}}).}
  \item{\code{gs_accl}}{Acclimated stomatal conductance (in 
      mol C (mol photons)\eqn{^{-1}} Pa\eqn{^{-1}}. (Multiply by 
      ppfd (mol photons m\eqn{^{-2}} d\eqn{^{-1}}) and fapar 
      to express per unit ground area and time.)}
  \item{\code{wscal}}{Relative soil water content, between 0 (permanent wilting 
      point, PWP) and 1 (field capacity, FC).}
  \item{\code{chi}}{Ratio of leaf-internal to ambient CO\eqn{_{2}}, ci:ca (unitless).}
  \item{\code{iwue}}{Intrinsic water use efficiency (iWUE) (unitless, 
      multiply with patm (Pa) to get iWUE in Pa).}
  \item{\code{rd}}{Dark respiration (Rd) in gC m\eqn{^{-2}} s\eqn{^{-1}}. 
      (Multiply by 1/12 (mol C / gC) to convert to mol C m\eqn{^{-2}} s\eqn{^{-1}}.)}
  \item{\code{tsoil}}{Soil temperature, in \eqn{^{o}}C.}
  \item{\code{netrad}}{Net radiation, in W m\eqn{^{-2}}. WARNING: this is currently ignored as a model forcing. Instead, net radiation is internally calculated by SPLASH.}
  \item{\code{wcont}}{Soil water content, in mm.}
  \item{\code{snow}}{Snow water equivalents, in mm.}
  \item{\code{cond}}{Water input by condensation, in mm d\eqn{^{-1}}}
  \item{\code{cleaf}}{C mass of a virtual leaf carbon pool to keep track of isotopic composition, in gC m\eqn{^{-2}}}
  \item{\code{cleafd13c}}{13C isotopic signature (delta) of \code{cleaf}, in permil.}
  }
}
\description{
Run P-model on a single site for a forcing time series.
}
\details{
Depending on the input model parameters, it's possible to run the 
different P-model setups presented in Stocker et al. 2020 GMD. The P-model
version implemented in this package allows more flexibility than the one
presented in the paper, with the following functions:

The temperature dependence of the quantum yield efficiency is given by: \cr
\eqn{\varphi_0 (T) = c (1 + a (T - b)^2 ) } if \eqn{0 < c (1 + a (T - b)^2 ) < 1}, \cr
\eqn{\varphi_0 (T) = 0 } if \eqn{ c (1 + a (T - b)^2 ) \leq 0}, and  \cr
\eqn{\varphi_0 (T) = 1 } if \eqn{ c (1 + a (T - b)^2 ) \geq 1}. \cr
The ORG setup can be reproduced by setting \code{kphio_par_a = 0}
and calibrating the \code{kphio} parameter only.
The BRC setup (which calibrates \eqn{c_L = \frac{a_L b_L}{4}} in Eq. 18) is more difficult to reproduce, 
since the temperature-dependency has been reformulated and a custom cost
function would be necessary for calibration. The new parameters
are related to \eqn{c_L} as follows: \cr
\eqn{a = -0.0004919819} \cr
\eqn{b = 32.35294} \cr
\eqn{c = 0.6910823 c_L} 

The soil moisture stress is implemented as \cr
\eqn{\beta(\theta) = \frac{\beta_0 - 1}{{\theta^{*}}^2} 
   (\theta - \theta^{*})^2 + 1 } if 
   \eqn{ 0 \leq \theta \leq \theta^{*}} and \cr
\eqn{\beta(\theta) = 1} if \eqn{ \theta > \theta^{*}}. \cr
In Stocker et al. 2020 GMD, the threshold plant-available soil water is set as
\eqn{\theta^{*}} 
\code{= 0.6 * whc} where \code{whc} is the site's water holding capacity. Also,
the \eqn{\beta} reduction at low soil moisture (\eqn{\beta_0 = \beta(0)}) was parameterized
as a linear function of mean aridity (Eq. 20 in Stocker et al. 2020 GMD) but is
considered a constant model parameter in this package. 
Hence, the FULL calibration setup cannot be 
exactly replicated.
}
\examples{
# Define model parameter values from previous work
params_modl <- list(
  kphio              = 0.04998,    # setup ORG in Stocker et al. 2020 GMD
  kphio_par_a        = 0.0,        # disable temperature-dependence of kphio
  kphio_par_b        = 1.0,
  soilm_thetastar    = 0.6 * 240,  # old setup with soil moisture stress
  soilm_betao        = 0.0,
  beta_unitcostratio = 146.0,
  rd_to_vcmax        = 0.014,      # from Atkin et al. 2015 for C3 herbaceous
  tau_acclim         = 30.0,
  kc_jmax            = 0.41
)

# Run the Fortran P-model 
mod_output <- run_pmodel_f_bysite(
  # unnest drivers example data
  sitename = p_model_drivers$sitename[1],
  params_siml = p_model_drivers$params_siml[[1]],
  site_info = p_model_drivers$site_info[[1]],
  forcing = p_model_drivers$forcing[[1]],
  params_modl = params_modl
 )
}
