% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikT}
\alias{llikT}
\title{Log likelihood of T and it's derivatives (from stan)}
\usage{
llikT(x, df, mean = 0, sd = 1, full = FALSE)
}
\arguments{
\item{x}{Observation}

\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{mean}{Mean for the likelihood}

\item{sd}{Standard deviation for the likelihood}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with \code{dDf}
\code{dMean} and \code{dSd} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
Log likelihood of T and it's derivatives (from stan)
}
\examples{

x <- seq(-3, 3, length.out = 21)

llikT(x, 7, 0, 1)

llikT(x, 15, 0, 1, full=TRUE)

}
\author{
Matthew L. Fidler
}
