% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_VI_prob_cluster_alloc.R
\name{plot_vi_allocation_prob}
\alias{plot_vi_allocation_prob}
\title{Plot Variational Cluster Allocation Probabilities}
\usage{
plot_vi_allocation_prob(object, distributional = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{SANvi}, representing a model fitted via variational inference.}

\item{distributional}{Logical (default \code{FALSE}). If \code{FALSE}, plots the allocation probabilities of individual observations to observational clusters (OC). If \code{TRUE}, plots the allocation probabilities of groups to distributional clusters (DC).}

\item{...}{Additional graphical parameters passed to the underlying \code{image()} function (or equivalent), for customizing the plot (e.g., \code{col}, \code{main}, \code{xlab}, \code{ylab}).}
}
\value{
The function plots the variational cluster allocation probabilities.
}
\description{
Produces visualizations of the posterior cluster allocation probabilities from a SAN model fitted via variational inference.
The function supports plotting either the observation-level (OC) or distribution-level (DC) allocation probabilities, depending on the argument \code{distributional}.

This function applies to objects returned by \code{\link{fit_CAM}}, \code{\link{fit_fiSAN}}, or \code{\link{fit_fSAN}} when used with \code{est_method = "VI"}.
}
\examples{
# Generate example data
set.seed(123)
y <- c(rnorm(60), rnorm(40, 5))
g <- rep(1:2, each = 50)

# Fit fiSAN via VI
est <- fit_fiSAN(y, g, est_method = "VI")

# Plot observational cluster probabilities
plot_vi_allocation_prob(est)

# Plot distributional cluster probabilities
plot_vi_allocation_prob(est, distributional = TRUE)

}
