% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-exists.R
\name{sas_file_exists}
\alias{sas_file_exists}
\title{Check if file on SAS exists}
\usage{
sas_file_exists(path)
}
\arguments{
\item{path}{string; Path of file on remote SAS server.}
}
\value{
\code{logical}; value indicating if the operation succeeded.
}
\description{
Checks if a file exists on the remote SAS server. Is analogous to
\code{file.exists()}, but for the remote SAS server.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# connect to SAS
sas_connect()

# create an example file
local_path <- tempfile(fileext = ".txt")
cat("some example text", file = tempfile_path)

sas_path <- readline(
  "Please provide the full path to upload an example file to (e.g., ~/example.txt)."
)
sas_file_upload(local_path, sas_path)

sas_file_exists(sas_path)

# cleanup
unlink(local_path)
sas_file_remove(sas_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other file management functions: 
\code{\link{sas_file_copy}()},
\code{\link{sas_file_download}()},
\code{\link{sas_file_remove}()},
\code{\link{sas_file_upload}()},
\code{\link{sas_list}()}
}
\concept{file management functions}
