% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Statistics.R
\name{Proportion_Plot_per_Sample}
\alias{Proportion_Plot_per_Sample}
\title{Cell Proportion Plot per Sample}
\usage{
Proportion_Plot_per_Sample(
  seurat_object,
  cluster = "ident",
  split.by,
  sample_col,
  pt.size = 1.5,
  x_lab_rotate = TRUE,
  colors_use = NULL,
  ggplot_default_colors = FALSE,
  color_seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{cluster}{name of meta.data column containing cluster values.  Default is \code{ident}
which defaults to current active.ident.}

\item{split.by}{name of meta.data column containing sample group/condition variable.}

\item{sample_col}{name of meta.data column that contains sample ID information.}

\item{pt.size}{the size of points in plot (default is 1.5).}

\item{x_lab_rotate}{Rotate x-axis labels 45 degrees (Default is FALSE). Only valid if \code{plot_type = "bar"}.}

\item{colors_use}{color palette to use for plotting.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}
}
\description{
Plots the proportion of cells belonging to each identity per sample split by grouping
variable/condition.
}
\examples{
\dontrun{
Proportion_Plot_per_Sample(seurat_object = obj, split.by = "Diagnosis",
sample_col = "orig.ident")
}

}
\concept{stats_plotting}
