% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{scMetaTraj_cluster}
\alias{scMetaTraj_cluster}
\title{Cluster cells in metabolic PCA space}
\usage{
scMetaTraj_cluster(
  embedding,
  k = 20,
  resolution = 0.5,
  method = c("leiden", "louvain"),
  seed = 123
)
}
\arguments{
\item{embedding}{Numeric matrix (cells x PCs).
Output of scMetaTraj_embed(method = "PCA").}

\item{k}{Integer. Number of nearest neighbors for kNN graph.}

\item{resolution}{Numeric. Resolution parameter for clustering
(used for Leiden only).}

\item{method}{Character. "leiden" (default) or "louvain".}

\item{seed}{Integer. Random seed for reproducibility.}
}
\value{
A factor of length equal to number of cells,
giving metabolic cluster labels per cell.
}
\description{
scMetaTraj_cluster() identifies metabolic subclusters by constructing
a kNN graph in metabolic PCA space and applying community detection.

IMPORTANT DESIGN PRINCIPLES:
\itemize{
\item Clustering is performed ONLY in metabolic PCA space.
\item UMAP coordinates must NEVER be used for clustering.
\item Results are independent of transcriptomic clustering.
}
}
\examples{
# Create example PCA embedding
set.seed(123)
n_cells <- 100
n_pcs <- 5

embedding <- matrix(rnorm(n_cells * n_pcs), nrow = n_cells, ncol = n_pcs)
rownames(embedding) <- paste0("Cell", 1:n_cells)
colnames(embedding) <- paste0("PC", 1:n_pcs)

# Perform clustering
clusters <- scMetaTraj_cluster(
  embedding = embedding,
  k = 20,
  method = "louvain"
)

# View results
table(clusters)

}
