% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_chisq_test_table.R
\name{make_chisq_test_table}
\alias{make_chisq_test_table}
\title{Create a one-row summary table for a chi-square test}
\usage{
make_chisq_test_table(
  chisq_object,
  test_type = c("goodness-of-fit", "independence", "homogeneity")
)
}
\arguments{
\item{chisq_object}{An object of class \code{"htest"} produced by
\code{stats::chisq.test()}.}

\item{test_type}{Character string specifying the type of chi-square test.
One of \code{"goodness-of-fit"}, \code{"independence"}, or
\code{"homogeneity"}.}
}
\value{
A single-row data frame with the following columns:
\itemize{
\item \code{test}: Type of chi-square test
\item \code{chi_square}: Chi-square statistic
\item \code{df}: Degrees of freedom
\item \code{p_value}: p-value
\item \code{N}: Total sample size
\item \code{effect_size}: Effect size (Cohen’s w or Cramér’s V)
\item \code{effect_type}: Type of effect size reported
\item \code{effect_interpretation}: Qualitative interpretation of effect size
}
}
\description{
This function formats the result of a pre-computed \code{chisq.test()}
into a single-row, report-ready data frame. It supports goodness-of-fit,
independence, and homogeneity chi-square tests and includes an appropriate
effect size with a qualitative interpretation.
}
\details{
The function does not perform the chi-square test itself and does not
introduce new statistical methods. All test statistics are extracted
directly from the supplied \code{chisq.test()} object.

For goodness-of-fit tests, Cohen’s w is reported. For tests of independence
and homogeneity, Cramér’s V is reported. Effect size interpretations follow
conventional benchmarks (0.10 = small, 0.30 = medium, 0.50 = large).
}
\examples{
# Goodness-of-fit example
observed <- c(40, 30, 50)
chisq_gof <- chisq.test(observed)

make_chisq_test_table(
  chisq_object = chisq_gof,
  test_type = "goodness-of-fit"
)

# Independence test example
tbl <- matrix(c(20, 30, 10, 40), nrow = 2)
chisq_ind <- chisq.test(tbl)

make_chisq_test_table(
  chisq_object = chisq_ind,
  test_type = "independence"
)

}
