% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{convert_u}
\alias{convert_u}
\title{Convert unit in equation}
\usage{
convert_u(x, unit_def)
}
\arguments{
\item{x}{Variable}

\item{unit_def}{Unit definition, e.g. u('seconds')}
}
\value{
Variable with new unit (only in Julia)
}
\description{
In rare cases, it may be desirable to change the units of a variable within an equation. Use \code{\link[=convert_u]{convert_u()}} to convert a variable to another matching unit. See \code{\link[=u]{u()}} for more information on the rules of specifying units. Note that units are only supported in Julia, not in R.
}
\examples{
# Change the unit of rate from minutes to hours
sfm <- xmile() |>
  build("rate", "constant", eqn = "10", units = "minutes") |>
  build("change", "flow",
    eqn = "(room_temperature - coffee_temperature) / convert_u(rate, u('hour'))"
  )

}
\seealso{
\code{\link[=model_units]{model_units()}}, \code{\link[=unit_prefixes]{unit_prefixes()}}, \code{\link[=u]{u()}}, \code{\link[=drop_u]{drop_u()}}
}
\concept{units}
