% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise.R
\name{plot.sdbuildR_xmile}
\alias{plot.sdbuildR_xmile}
\title{Plot stock-and-flow diagram}
\usage{
\method{plot}{sdbuildR_xmile}(
  x,
  vars = NULL,
  format_label = TRUE,
  wrap_width = 20,
  font_size = 18,
  font_family = "Times New Roman",
  stock_col = "#83d3d4",
  flow_col = "#f48153",
  dependency_col = "#999999",
  show_dependencies = TRUE,
  show_constants = FALSE,
  show_aux = TRUE,
  minlen = 2,
  ...
)
}
\arguments{
\item{x}{A stock-and-flow model object of class \code{\link[=xmile]{sdbuildR_xmile}}.}

\item{vars}{Variables to plot. Defaults to NULL to plot all variables.}

\item{format_label}{If TRUE, apply default formatting (removing periods and underscores) to labels if labels are the same as variable names.}

\item{wrap_width}{Width of text wrapping for labels. Must be an integer. Defaults to 20.}

\item{font_size}{Font size. Defaults to 18.}

\item{font_family}{Font name. Defaults to "Times New Roman".}

\item{stock_col}{Colour of stocks. Defaults to "#83d3d4".}

\item{flow_col}{Colour of flows. Defaults to "#f48153".}

\item{dependency_col}{Colour of dependency arrows. Defaults to "#999999".}

\item{show_dependencies}{If TRUE, show dependencies between variables. Defaults to TRUE.}

\item{show_constants}{If TRUE, show constants. Defaults to FALSE.}

\item{show_aux}{If TRUE, show auxiliary variables. Defaults to TRUE.}

\item{minlen}{Minimum length of edges; must be an integer. Defaults to 2.}

\item{...}{Optional arguments}
}
\value{
Stock-and-flow diagram
}
\description{
Visualize a stock-and-flow diagram using the R package DiagrammeR. Stocks are represented as boxes. Flows are represented as arrows between stocks and/or double circles, where the latter represent what it outside of the model boundary. Thin grey edges indicate dependencies between variables. By default, constants (indicated by italic labels) are not shown. Hover over the variables to see their equations.
}
\examples{
sfm <- xmile("SIR")
plot(sfm)

# Don't show constants or auxiliaries
plot(sfm, show_constants = FALSE, show_aux = FALSE)

# Only show specific variables
plot(sfm, vars = "Susceptible")

}
\seealso{
\code{\link[=insightmaker_to_sfm]{insightmaker_to_sfm()}}, \code{\link[=xmile]{xmile()}}, \code{\link[=plot.sdbuildR_sim]{plot.sdbuildR_sim()}}
}
\concept{build}
