% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather-spread.R
\name{spread_sims}
\alias{spread_sims}
\alias{gather_sims}
\title{Extract parameter simulations from the joint precision matrix}
\usage{
spread_sims(object, nsim = 200)

gather_sims(object, nsim = 200)
}
\arguments{
\item{object}{Output from \code{\link[=sdmTMB]{sdmTMB()}}.}

\item{nsim}{The number of simulation draws.}
}
\value{
A data frame. \code{gather_sims()} returns a long-format data frame:
\itemize{
\item \code{.iteration}: the sample ID
\item \code{.variable}: the parameter name
\item \code{.value}: the parameter sample value
}

\code{spread_sims()} returns a wide-format data frame:
\itemize{
\item \code{.iteration}: the sample ID
\item columns for each parameter with a sample per row
}
}
\description{
\code{spread_sims()} returns a wide-format data frame. \code{gather_sims()} returns a
long-format data frame. The format matches the format in the \pkg{tidybayes}
\code{spread_draws()} and \code{gather_draws()} functions.
}
\examples{
m <- sdmTMB(density ~ depth_scaled,
  data = pcod_2011, mesh = pcod_mesh_2011, family = tweedie())
head(spread_sims(m, nsim = 10))
head(gather_sims(m, nsim = 10))
samps <- gather_sims(m, nsim = 1000)

if (require("ggplot2", quietly = TRUE)) {
  ggplot(samps, aes(.value)) + geom_histogram() +
    facet_wrap(~.variable, scales = "free_x")
}
}
