% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden_paths.R
\name{hidden_paths}
\alias{hidden_paths}
\alias{hidden_paths.hmm}
\alias{hidden_paths.mhmm}
\alias{hidden_paths.nhmm}
\alias{hidden_paths.mnhmm}
\title{Most Probable Paths of Hidden States}
\usage{
hidden_paths(model, ...)

\method{hidden_paths}{hmm}(model, as_stslist = FALSE, ...)

\method{hidden_paths}{mhmm}(model, as_stslist = FALSE, ...)

\method{hidden_paths}{nhmm}(model, as_stslist = FALSE, ...)

\method{hidden_paths}{mnhmm}(model, as_stslist = FALSE, ...)
}
\arguments{
\item{model}{A hidden Markov model.}

\item{...}{Ignored.}

\item{as_stslist}{Logical. If \code{TRUE}, the output the is converted to an
\code{stslist} object. Default is \code{FALSE}, which returns a \code{data.table}.}
}
\value{
The most probable paths of hidden states as an \code{data.table}.
The log-probability is included as an attribute
\code{log_prop}.
}
\description{
Function \code{hidden_paths} computes the most probable path of
hidden states of a (mixture) hidden Markov model given the observed sequences.
}
\examples{
# Load a pre-defined HMM
data("hmm_biofam")

# Compute the most probable hidden state paths given the data and the model
mpp <- hidden_paths(hmm_biofam)
head(mpp)
# Plot hidden paths for the first 100 individuals
seqs <- data_to_stslist(mpp, "id", "time", "state")
stacked_sequence_plot(seqs, type = "i", ids = 1:100)

# Because the model structure is so sparse that the posterior probabilities are
# mostly peaked to single state at each time point, the joint probability of
# observations and most probable paths of hidden states is almost identical to
# log-likelihood:

sum(attr(mpp, "log_prob"))
logLik(hmm_biofam)

}
\seealso{
\link{hmm_biofam} for information on the model used in the example;
and \code{\link[ggseqplot:ggseqiplot]{ggseqplot::ggseqiplot()}} and \code{\link[=stacked_sequence_plot]{stacked_sequence_plot()}}
for plotting hidden paths.
}
