% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_hmm.R
\name{trim_model}
\alias{trim_model}
\title{Trim Small Probabilities of Hidden Markov Model}
\usage{
trim_model(
  model,
  maxit = 0,
  return_loglik = FALSE,
  zerotol = 1e-08,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{Model of class \code{hmm} or \code{mhmm} for which
trimming is performed.}

\item{maxit}{Number of iterations. After zeroing small values, the model is
refitted, and this is repeated until there is nothing to trim or \code{maxit}
iterations are done.}

\item{return_loglik}{Return the log-likelihood of the trimmed model together with
the model object. The default is \code{FALSE}.}

\item{zerotol}{Values smaller than this are trimmed to zero.}

\item{verbose}{Print results of trimming. The default is \code{TRUE}.}

\item{...}{Further parameters passed on to \code{\link[=fit_model]{fit_model()}}.}
}
\description{
Function \code{trim_model} tries to set small insignificant probabilities to zero
without decreasing the likelihood.
}
\examples{
data("hmm_biofam")

# Testing if changing parameter values smaller than 1e-03 to zero
# leads to improved log-likelihood.
hmm_trim <- trim_model(hmm_biofam, zerotol = 1e-03, maxit = 10)
}
\seealso{
\code{\link[=build_hmm]{build_hmm()}} and \code{\link[=fit_model]{fit_model()}} for building and fitting
hidden Markov models; and \code{\link[=hmm_biofam]{hmm_biofam()}} for information on the model used
in the example.
}
