% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R, R/proj.R
\name{st_transform}
\alias{st_transform}
\alias{st_can_transform}
\alias{st_transform.sfc}
\alias{st_transform.sf}
\alias{st_transform.sfg}
\alias{st_transform.bbox}
\alias{st_wrap_dateline}
\alias{st_wrap_dateline.sfc}
\alias{st_wrap_dateline.sf}
\alias{st_wrap_dateline.sfg}
\alias{sf_proj_info}
\title{Transform or convert coordinates of simple feature}
\usage{
st_can_transform(src, dst)

st_transform(x, crs, ...)

\method{st_transform}{sfc}(
  x,
  crs = st_crs(x),
  ...,
  aoi = numeric(0),
  pipeline = character(0),
  reverse = FALSE,
  desired_accuracy = -1,
  allow_ballpark = TRUE,
  partial = TRUE,
  check = FALSE
)

\method{st_transform}{sf}(x, crs = st_crs(x), ...)

\method{st_transform}{sfg}(x, crs = st_crs(x), ...)

\method{st_transform}{bbox}(x, crs, ..., densify = 21)

st_wrap_dateline(x, options, quiet)

\method{st_wrap_dateline}{sfc}(x, options = "WRAPDATELINE=YES", quiet = TRUE)

\method{st_wrap_dateline}{sf}(x, options = "WRAPDATELINE=YES", quiet = TRUE)

\method{st_wrap_dateline}{sfg}(x, options = "WRAPDATELINE=YES", quiet = TRUE)

sf_proj_info(type = "proj", path)
}
\arguments{
\item{src}{source crs}

\item{dst}{destination crs}

\item{x}{object of class sf, sfc or sfg}

\item{crs}{target coordinate reference system: object of class \code{crs}, or input string for \link{st_crs}}

\item{...}{ignored}

\item{aoi}{area of interest, in degrees:
WestLongitude, SouthLatitude, EastLongitude, NorthLatitude}

\item{pipeline}{character; coordinate operation pipeline, for overriding the default operation}

\item{reverse}{boolean; has only an effect when \code{pipeline} is defined:
if \code{TRUE}, the inverse operation of the pipeline is applied}

\item{desired_accuracy}{numeric; Only coordinate operations that offer an accuracy of
at least the one specified will be considered; a negative value disables this feature
(requires GDAL >= 3.3)}

\item{allow_ballpark}{logical; are ballpark (low accuracy) transformations allowed?
(requires GDAL >= 3.3)}

\item{partial}{logical; allow for partial projection, if not all points of a geometry can be projected (corresponds to setting environment variable \code{OGR_ENABLE_PARTIAL_REPROJECTION} to \code{TRUE})}

\item{check}{logical; if \code{TRUE}, perform a sanity check on resulting polygons}

\item{densify}{integer, number of points for discretizing lines between bounding box corner points; see Details}

\item{options}{character; should have "WRAPDATELINE=YES" to function; another parameter that is used is "DATELINEOFFSET=10" (where 10 is the default value)}

\item{quiet}{logical; print options after they have been parsed?}

\item{type}{character; one of \code{have_datum_files}, \code{proj}, \code{ellps}, \code{datum}, \code{units}, \code{path}, or \code{prime_meridians}; see Details.}

\item{path}{character; PROJ search path to be set}
}
\description{
Transform or convert coordinates of simple feature
}
\details{
\code{st_can_transform} returns a boolean indicating whether
coordinates with CRS src can be transformed into CRS dst

Transforms coordinates of object to new projection.
Features that cannot be transformed are returned as empty geometries.
Transforms using the \code{pipeline=} argument may fail if there is
ambiguity in the axis order of the specified coordinate reference system;
if you need the traditional GIS order, use \code{"OGC:CRS84"}, not
\code{"EPSG:4326"}. Extra care is needed with the ESRI Shapefile format,
because WKT1 does not store axis order unambiguously.

The \code{st_transform} method for \code{sfg} objects assumes that the CRS of the object is available as an attribute of that name.

the method for \code{bbox} objects densifies lines for geographic coordinates along Cartesian lines, not great circle arcs

For a discussion of using \code{options}, see \url{https://github.com/r-spatial/sf/issues/280} and \url{https://github.com/r-spatial/sf/issues/1983}

\code{sf_proj_info} lists the available projections, ellipses, datums, units, or data search path of the PROJ library when \code{type} is equal to proj, ellps, datum, units or path; when \code{type} equals \code{have_datum_files} a boolean is returned indicating whether datum files are installed and accessible (checking for \code{conus}). \code{path} returns the \code{PROJ_INFO.searchpath} field directly, as a single string with path separaters (\code{:}  or \verb{;}).

for PROJ >= 6, \code{sf_proj_info} does not provide option \code{type = "datums"}.
PROJ < 6 does not provide the option \code{type = "prime_meridians"}.

for PROJ >= 7.1.0, the "units" query of \code{sf_proj_info} returns the \code{to_meter}
variable as numeric, previous versions return a character vector containing a numeric expression.
}
\examples{
p1 = st_point(c(7,52))
p2 = st_point(c(-30,20))
sfc = st_sfc(p1, p2, crs = 4326)
sfc
st_transform(sfc, 3857)
st_transform(st_sf(a=2:1, geom=sfc), "EPSG:3857")
if (compareVersion(sf_extSoftVersion()["GDAL"], "3.0.0") >= 0) {
  st_transform(sfc, pipeline =
	  "+proj=pipeline +step +proj=axisswap +order=2,1") # reverse axes
  st_transform(sfc, pipeline =
	  "+proj=pipeline +step +proj=axisswap +order=2,1", reverse = TRUE) # also reverse axes
}
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_area(nc[1,]) # area from long/lat
st_area(st_transform(nc[1,], 32119)) # NC state plane, m
st_area(st_transform(nc[1,], 2264)) # NC state plane, US foot
library(units)
set_units(st_area(st_transform(nc[1,], 2264)), m^2)
st_transform(structure(p1, proj4string = "EPSG:4326"), "EPSG:3857")
st_wrap_dateline(st_sfc(st_linestring(rbind(c(-179,0),c(179,0))), crs = 4326))
sf_proj_info("datum")
}
\seealso{
\link[lwgeom]{st_transform_proj}, part of package lwgeom.

\link{sf_project} projects a matrix of coordinates, bypassing GDAL altogether

\link{st_break_antimeridian}
}
