% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSS2LL.R
\name{PLSS2LL}
\alias{PLSS2LL}
\title{Lookup Geographic Coordinates for Public Land Survey System Descriptions}
\usage{
PLSS2LL(p, plssid = "plssid")
}
\arguments{
\item{p}{\code{data.frame} containing (at least) PLSS aliquot part identifiers. These can be generated by \code{\link[=formatPLSS]{formatPLSS()}}.}

\item{plssid}{column name containing PLSS aliquot part identifiers.}
}
\value{
A \code{data.frame} of PLSS codes and coordinates.
}
\description{
Fetch geographic coordinates by Public Land Survey System (PLSS)  description from the BLM PLSS web service. Coordinates represent the centroid of each PLSS aliquot defined in \code{p}.
}
\note{
Requires the following packages: httr and jsonlite.
}
\seealso{
\code{\link[=LL2PLSS]{LL2PLSS()}}, \code{\link[=formatPLSS]{formatPLSS()}}
}
\author{
D.E. Beaudette, Jay Skovlin, A.G. Brown
}
