% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component.adj.matrix.R
\name{component.adj.matrix}
\alias{component.adj.matrix}
\title{Create an adjacency matrix from a data.frame of component data}
\usage{
component.adj.matrix(
  d,
  mu = "mukey",
  co = "compname",
  wt = "comppct_r",
  method = c("community.matrix", "occurrence"),
  standardization = "max",
  metric = "jaccard",
  rm.orphans = TRUE,
  similarity = TRUE,
  return.comm.matrix = FALSE
)
}
\arguments{
\item{d}{\code{data.frame}, typically of SSURGO data}

\item{mu}{name of the column containing the map unit ID (typically 'mukey')}

\item{co}{name of the column containing the component ID (typically 'compname')}

\item{wt}{name of the column containing the component weight percent (typically 'comppct_r')}

\item{method}{one of either: \code{community.matrix}, or \code{occurrence}; see details}

\item{standardization}{community matrix standardization method, passed to \code{vegan::decostand}}

\item{metric}{community matrix dissimilarity metric, passed to \code{vegan::vegdist}}

\item{rm.orphans}{\code{logical}, should map units with a single component be omitted? (typically yes)}

\item{similarity}{logical, return a similarity matrix? (if \code{FALSE}, a distance matrix is returned)}

\item{return.comm.matrix}{logical, return pseudo-community matrix? (if \code{TRUE} no adjacency matrix is created)}
}
\value{
A similarity or adjacency matrix suitable for use with \code{igraph} functions or anything else that can accommodate a \emph{similarity} matrix.
}
\description{
Create an adjacency matrix from SSURGO component data
}
\examples{
\donttest{
if (requireNamespace("igraph") && requireNamespace("vegan")) {
  # load sample data set
  data(amador)

  # convert into adjacency matrix
  m <- component.adj.matrix(amador)

  # plot network diagram, with Amador soil highlighted
  plotSoilRelationGraph(m, s = 'amador')
}
}
}
\author{
D.E. Beaudette
}
\keyword{manip}
