% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateFilterInput.R
\name{updateFilterInput}
\alias{updateFilterInput}
\title{Update a \pkg{shiny} Input}
\usage{
updateFilterInput(x, ...)
}
\arguments{
\item{x}{The object used to create the input.}

\item{...}{Arguments used for input selection or passed to the selected
input update function. See details.}
}
\value{
The result of the following \pkg{shiny} input updates is returned,
based on the type of object passed to \code{x}, and other specified arguments.

\tabular{lll}{
\strong{Value}          \tab \strong{\code{x}}                     \tab \strong{Arguments}              \cr

\link[shiny:updateDateInput]{shiny::updateDateInput}      \tab Date, POSIXt                     \tab \emph{default}                       \cr
\link[shiny:updateDateRangeInput]{shiny::updateDateRangeInput} \tab Date, POSIXt                     \tab \code{range = TRUE}                  \cr
\link[shiny:updateNumericInput]{shiny::updateNumericInput}   \tab numeric                          \tab \emph{default}                       \cr
\link[shiny:updateRadioButtons]{shiny::updateRadioButtons}   \tab character, factor, list, logical \tab \code{radio = TRUE}                  \cr
\link[shiny:updateSelectInput]{shiny::updateSelectInput}    \tab character, factor, list, logical \tab \emph{default}                       \cr
\link[shiny:updateSelectInput]{shiny::updateSelectizeInput} \tab character, factor, list, logical \tab \code{selectize = TRUE}              \cr
\link[shiny:updateSliderInput]{shiny::updateSliderInput}    \tab numeric                          \tab \code{slider = TRUE}                 \cr
\link[shiny:updateTextAreaInput]{shiny::updateTextAreaInput}  \tab character                        \tab \code{textbox = TRUE}, \code{area = TRUE} \cr
\link[shiny:updateTextInput]{shiny::updateTextInput}      \tab character                        \tab \code{textbox = TRUE}                \cr
}
}
\description{
Updates a \pkg{shiny} input based the type of object \code{x} and other arguments.
}
\details{
The following arguments passed to \code{...} are supported:
\describe{
\item{area}{
\emph{(character)}. Logical. Controls whether to use  \link[shiny:updateTextAreaInput]{shiny::updateTextAreaInput}
(\code{TRUE}) or \link[shiny:updateTextInput]{shiny::updateTextInput} (\code{FALSE}, default). Only applies when
\code{textbox} is \code{TRUE}.}

\item{radio}{
\emph{(character, factor, list, logical)}. Logical. Controls whether to use
\link[shiny:updateRadioButtons]{shiny::updateRadioButtons} (\code{TRUE}) or a dropdown input update function
(\code{FALSE}, default). For character vectors, \code{radio} only applies if
\code{textbox} is \code{FALSE}, the default.}

\item{range}{
\emph{(Date, POSIXt)}. Logical. Controls whether to use \link[shiny:updateDateRangeInput]{shiny::updateDateRangeInput}
(\code{TRUE}) or \link[shiny:updateDateInput]{shiny::updateDateInput} (\code{FALSE}, default).}

\item{selectize}{
\emph{(character, factor, list, logical)}. Logical. Controls whether to use
\link[shiny:updateSelectInput]{shiny::updateSelectizeInput} (\code{TRUE}) or \link[shiny:updateSelectInput]{shiny::updateSelectInput}
(\code{FALSE}, default). For character vectors, \code{selectize} only applies if
\code{textbox} is \code{FALSE}, the default.}

\item{slider}{
\emph{(numeric)}. Logical. Controls whether to use \link[shiny:updateSliderInput]{shiny::updateSliderInput}
(\code{TRUE}) or \link[shiny:updateNumericInput]{shiny::updateNumericInput} (\code{FALSE}, default).}

\item{textbox}{
\emph{(character)}. Logical. Controls whether to update a text input
(\code{TRUE}) or a dropdown input (\code{FALSE}, default).}

}

Remaining arguments passed to \code{...} are passed to
\code{\link[=args_update_filter_input]{args_update_filter_input()}} or the selected input update function.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)

fruits <- list(
	"a" = c("apples", "avocados"),
	"b" = c("bananas", "blueberries"),
	"c" = c("cherries", "cantaloupe")
)

ui <- fluidPage(
	sidebarLayout(
		sidebarPanel(
			filterInput(
				x = letters[1:3],
				inputId = "letter",
				label = "Pick a letter:",
       multiple = TRUE
			),
			filterInput(
				x = fruits,
				inputId = "fruits",
				label = "Pick a fruit:"
			)
		),
   mainPanel()
	)
)

server <- function(input, output, session) {
	shiny::observe({
		fruits_filtered <- fruits
		if (!is.null(input$letter) && length(input$letter) != 0L) {
			fruits_filtered <- fruits[input$letter]
		}
		# Call updateFilterInput() inside the shiny server:
		updateFilterInput(x = fruits_filtered, inputId = "fruits")
	})
}
shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
