% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaSimTreat.R
\name{alphaSimTreat}
\alias{alphaSimTreat}
\title{Simulation and Estimation in Treatment Setting with Modified Eta Parameter of Treatment Process}
\usage{
alphaSimTreat(
  N = 10000,
  alpha = 0.5,
  tau = 5,
  nu = rep(1.1, 4),
  eta = rep(0.1, 4),
  beta_L_A = 1,
  beta_L_D = 1,
  beta_A_D = -0.5,
  beta_A_L = -1,
  beta_L0_A = 1,
  lower = 10^(-300),
  upper = 300,
  cens = 0,
  return_data = FALSE,
  years_lost = FALSE,
  beta_L_A_prime = 0,
  beta_L_D_prime = 0,
  beta_A_D_prime = 0,
  beta_L0_A_prime = 0,
  beta_A_L_prime = 0,
  beta_L0_L_prime = 0,
  beta_L0_D_prime = 0,
  beta_L0_C_prime = 0,
  beta_L_C_prime = 0,
  beta_A_C_prime = 0,
  t_prime = 0
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate.}

\item{alpha}{Numeric. Multiplicative factor applied to the \eqn{\eta} parameter of the treatment process.}

\item{tau}{Numeric. Time point at which event proportions or years lost are compared.}

\item{nu}{Numeric vector of length 4. Scale parameters for Weibull hazards.}

\item{eta}{Numeric vector of length 4. Shape parameters for Weibull hazards.}

\item{beta_L_A}{Numeric. Effect of covariate L on treatment process A.}

\item{beta_L_D}{Numeric. Effect of covariate L on death process D.}

\item{beta_A_D}{Numeric. Effect of treatment process A on death process D.}

\item{beta_A_L}{Numeric. Effect of treatment process A on covariate L.}

\item{beta_L0_A}{Numeric. Effect of L0 on treatment process A.}

\item{lower}{Numeric. Lower bound for root-finding algorithm to invert cumulative hazard.}

\item{upper}{Numeric. Upper bound for root-finding algorithm.}

\item{cens}{Binary scalar. Indicates whether individuals are at risk of censoring (default \code{1}).}

\item{return_data}{Logical. If \code{TRUE} the simulated data is returned.}

\item{years_lost}{Logical. If \code{TRUE}, computes years lost instead of proportions.}

\item{beta_L_A_prime}{Numeric. Additional effect of covariate \code{L = 1} on treatment hazard. Default 0.}

\item{beta_L_D_prime}{Numeric. Additionalffect of covariate \code{L = 1} on death hazard. Default 0.}

\item{beta_A_D_prime}{Numeric. Effect of treatment \code{A = 1} on death hazard. Default 0.}

\item{beta_L0_A_prime}{Numeric. Effect of baseline covariate \code{L0} on treatment hazard. Default 0.}

\item{beta_A_L_prime}{Numeric. Effect of treatment \code{A = 1} on covariate hazard. Default 0.}

\item{beta_L0_L_prime}{Numeric. Effect of baseline covariate \code{L0} on covariate hazard. Default 0.}

\item{beta_L0_D_prime}{Numeric. Effect of baseline covariate \code{L0} on death hazard. Default 0.}

\item{beta_L0_C_prime}{Numeric. Effect of baseline covariate \code{L0} on censoring hazard. Default 0.}

\item{beta_L_C_prime}{Numeric. Effect of covariate \code{L = 1} on censoring hazard. Default 0.}

\item{beta_A_C_prime}{Numeric. Effect of treatment \code{A = 1} on censoring hazard. Default 0.}

\item{t_prime}{Numeric scalar or NULL. Time point where effects change (optional).}
}
\value{
A list containing:
\describe{
\item{effect_A}{Proportion or years lost of treated patients with and without intervention.}
\item{effect_death}{Proportion or years lost of deaths with and without intervention.}
}
Or the simulated data.
}
\description{
Simulation and Estimation in Treatment Setting with Modified Shape Parameter of Treatment Process
}
\details{
This function simulates event history data from the Treatment scenario (see function simTreatment).
The \eqn{\eta} parameter of the treatment process is multiplied by a factor \code{alpha}.
The function computes the proportion or years lost of death and treatment by time \eqn{\tau}.
}
\examples{
alphaSimTreat()
}
