% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_correlated_data.R
\name{blockDecayMat}
\alias{blockDecayMat}
\title{Create a block correlation matrix}
\usage{
blockDecayMat(ninds, nperiods, rho_w, r, pattern = "xsection", nclusters = 1)
}
\arguments{
\item{ninds}{The number of units (individuals) in each cluster in each period.}

\item{nperiods}{The number periods that data are observed.}

\item{rho_w}{The within-period/between-individual correlation coefficient between -1 and 1.}

\item{r}{The decay parameter if correlation declines over time, and can have values of
"exp" or "prop". See details.}

\item{pattern}{A string argument with options "xsection" (default) or "cohort".}

\item{nclusters}{An integer that indicates the number of matrices that will be generated.}
}
\value{
A single correlation matrix of size \code{nvars x nvars}, or a list of matrices of potentially
different sizes with length indicated by \code{nclusters}.

A single correlation matrix or a list of matrices of potentially
different sizes with length indicated by \code{nclusters}.
}
\description{
The function genBlockMat() generates correlation matrices that 
can accommodate clustered observations over time where the within-cluster 
between-individual correlation in the same time period can be different from the 
within-cluster between-individual correlation across time periods.The matrix
generated here can be used in function addCorGen().
}
\details{
Two general decay correlation structures are currently supported: a *cross-sectional* 
exchangeable structure and a *closed cohort* exchangeable structure. In the *cross-sectional* 
case, individuals or units in each time period are distinct. In the *closed cohort* structure, 
individuals or units are repeated in each time period. The desired structure is specified 
using \code{pattern}, which defaults to "xsection" if not specified. 

This function can generate correlation matrices of different sizes, depending on the 
combination of arguments provided. A single matrix will be generated when 
\code{nclusters == 1} (the default), and a list of matrices of matrices will be generated when
\code{nclusters > 1}.

If \code{nclusters > 1}, the length of \code{ninds} will depend on if sample sizes will vary by cluster
and/or period. There are three scenarios,  and function evaluates the length of \code{ninds} to 
determine which approach to take:

\itemize{

\item{if the sample size is the same for all clusters in all periods, \code{ninds} will be
a single value (i.e., length = 1).}

\item{if the sample size differs by cluster but is the same for each period within each cluster
each period, then \code{ninds} will have a value for each cluster (i.e., length = \code{nclusters}).} 

\item{if the sample size differs across clusters and across periods within clusters, \code{ninds} will have a
value for each cluster-period combination (i.e., length = \code{nclusters x nperiods}).} This option is
only valid when \code{pattern = "xsection"}.

}

In addition, \code{rho_w} and \code{r} can be specified as a single value (in which case they are consistent
across all clusters) or as a vector of length \code{nclusters}, in which case either one or 
both of these parameters can vary by cluster.

See vignettes for more details.
}
\examples{
blockDecayMat(ninds = 4, nperiods = 3, rho_w = .8, r = .9)
blockDecayMat(ninds = 4, nperiods = 3, rho_w = .8, r = .9, pattern = "cohort")

blockDecayMat(ninds = 2, nperiods = 3, rho_w = .8, r = .9, pattern = "cohort", nclusters=2)
blockDecayMat(ninds = c(2, 3), nperiods = 3, rho_w = c(.8,0.7), r = c(.9,.8), 
  pattern = "cohort", nclusters=2)
blockDecayMat(ninds = c(2, 3, 4, 4, 2, 1), nperiods = 3, rho_w = .8, r = .9, nclusters=2)

}
\references{
Li et al. Mixed-effects models for the design and analysis of stepped wedge 
cluster randomized trials: An overview. Statistical Methods in Medical Research. 
2021;30(2):612-639. doi:10.1177/0962280220932962
}
\seealso{
\code{\link{blockExchangeMat}} and \code{\link{addCorGen}}
}
\concept{correlated}
