% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_select.R
\name{sits_select}
\alias{sits_select}
\alias{sits_select.sits}
\alias{sits_select.raster_cube}
\alias{sits_select.default}
\title{Filter a data set (tibble or cube) for bands, tiles, and dates}
\usage{
sits_select(data, ...)

\method{sits_select}{sits}(
  data,
  ...,
  bands = NULL,
  start_date = NULL,
  end_date = NULL,
  dates = NULL,
  labels = NULL
)

\method{sits_select}{raster_cube}(
  data,
  ...,
  bands = NULL,
  start_date = NULL,
  end_date = NULL,
  dates = NULL,
  tiles = NULL
)

\method{sits_select}{default}(data, ...)
}
\arguments{
\item{data}{Tibble with time series or data cube.}

\item{...}{Additional parameters to be provided}

\item{bands}{Character vector with the names of the bands.}

\item{start_date}{Date in YYYY-MM-DD format: start date to be filtered.}

\item{end_date}{Date in YYYY-MM-DD format: end date to be filtered.}

\item{dates}{Character vector with sparse dates to be selected.}

\item{labels}{Character vector with sparse labels to be selected
(Only applied for sits tibble data).}

\item{tiles}{Character vector with the names of the tiles.}
}
\value{
Tibble with time series or data cube.
}
\description{
Filter the bands, tiles, dates and labels from a set of
 time series or from a data cube.
}
\examples{
# Retrieve a set of time series with 2 classes
data(cerrado_2classes)
# Print the original bands
sits_bands(cerrado_2classes)
# Select only the NDVI band
data <- sits_select(cerrado_2classes, bands = c("NDVI"))
# Print the labels of the resulting tibble
sits_bands(data)
# select start and end date
point_2010 <- sits_select(point_mt_6bands,
    start_date = "2000-09-13",
    end_date = "2017-08-29"
)

}
\author{
Rolf Simoes, \email{rolfsimoes@gmail.com}

Felipe Carlos, \email{efelipecarlos@gmail.com}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
