% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_AP.R
\name{theme_AP}
\alias{theme_AP}
\title{A clean, publication-oriented ggplot2 theme}
\usage{
theme_AP()
}
\value{
A \code{ggplot2::theme} object.
}
\description{
\code{theme_AP()} provides a minimalist, publication-ready theme based on
\code{\link[ggplot2:ggtheme]{ggplot2::theme_bw()}}, with grid lines removed, compact legends, and
harmonized text sizes. It is designed for dense network and path-visualization
plots (e.g. call graphs, risk paths).
}
\details{
The theme:
\itemize{
\item removes major and minor grid lines,
\item uses transparent legend backgrounds and keys,
\item standardizes text sizes for axes, legends, strips, and titles,
\item reduces legend spacing for compact layouts.
}

This theme is intended to be composable:
it should be added to a ggplot object using \code{+ theme_AP()}.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
ggplot2::ggplot(mtcars, ggplot2::aes(mpg, wt)) +
  ggplot2::geom_point() +
  theme_AP()

\dontshow{\}) # examplesIf}
}
