% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_utilities.R
\name{getPrior}
\alias{getPrior}
\title{Get prior for pitch candidates}
\usage{
getPrior(
  priorMean,
  priorSD,
  distribution = c("normal", "gamma")[1],
  pitchFloor = 75,
  pitchCeiling = 3000,
  len = 100,
  plot = TRUE,
  pitchCands = NULL,
  ...
)
}
\arguments{
\item{priorMean, priorSD}{specifies the mean (Hz) and standard deviation
(semitones) of gamma distribution describing our prior knowledge about the
most likely pitch values for this file. For ex., \code{priorMean = 300,
priorSD = 6} gives a prior with mean = 300 Hz and SD = 6 semitones (half
an octave). To avoid using any priors, set \code{priorMean = NA, priorAdapt
= FALSE}}

\item{distribution}{the shape of prior distribution on the musical scale:
'normal' (mode = priorMean) or 'gamma' (skewed to lower frequencies)}

\item{pitchFloor, pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{len}{the required length of output vector (resolution)}

\item{plot}{if TRUE, plots the prior}

\item{pitchCands}{a matrix of pitch candidate frequencies (for internal
soundgen use)}

\item{...}{additional graphical parameters passed on to plot()}
}
\value{
Returns a numeric vector of certainties of length \code{len} if
  pitchCands is NULL and a numeric matrix of the same dimensions as
  pitchCands otherwise.
}
\description{
Prior for adjusting the estimated pitch certainties in \code{\link{analyze}}.
For ex., if primarily working with speech, we could prioritize pitch
candidates in the expected pitch range (100-1000 Hz) and decrease our
confidence in candidates with very high or very low frequency as unlikely but
still remotely possible. You can think of this as a "soft" alternative to
setting absolute pitch floor and ceiling. Algorithm: the multiplier for each
pitch candidate is the density of prior distribution with mean = priorMean
(Hz) and sd = priorSD (semitones) normalized so max = 1 over \code{[pitchFloor,
pitchCeiling]}. Useful for previewing the prior given to
\code{\link{analyze}}.
}
\examples{
soundgen:::getPrior(priorMean = 150,  # Hz
                    priorSD = 2)      # semitones
soundgen:::getPrior(150, 6)
s = soundgen:::getPrior(450, 24, pitchCeiling = 6000)
plot(s, type = 'l')
}
\seealso{
\code{\link{analyze}} \code{\link{pitch_app}}
}
