% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacemodel.R
\name{raster_stack}
\alias{raster_stack}
\title{Create a RasterStack from a list of rasters and names}
\usage{
raster_stack(raster_list, names = NULL)
}
\arguments{
\item{raster_list}{A list of `SpatRaster` objects or file paths to raster files.}

\item{names}{A character vector of unique names for each raster layer in the stack.}
}
\value{
A \code{\link[terra]{SpatRaster}} object with named layers.
}
\description{
This function creates a `SpatRaster` stack from a list of rasters and assigns unique names to each layer.
}
\details{
The function checks that the length of `raster_list` matches the length of `names`,
and that all names are unique. If not, it stops with an error.
}
\examples{
# Example with terra rasters
library(terra)
r1 <- rast(nrows=10, ncols=10, vals=1:100)
r2 <- rast(nrows=10, ncols=10, vals=101:200)
raster_stack(list(r1, r2), c("layer1", "layer2"))

}
