% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-prcomp.R
\name{autoplot.prcomp_qts}
\alias{autoplot.prcomp_qts}
\title{Plot for \code{prcomp_qts} objects}
\usage{
\method{autoplot}{prcomp_qts}(object, what = "PC1", ...)
}
\arguments{
\item{object}{An object of class \code{prcomp_qts} as produced by the
\code{\link[=prcomp.qts_sample]{prcomp.qts_sample()}} method.}

\item{what}{A string specifying what kind of visualization the user wants to
perform. Choices are words starting with \code{PC} and ending with a PC number
(in which case the mean QTS is displayed along with its perturbations due
to the required PC) or \code{scores} (in which case individuals are projected on
the required plane). Defaults to \code{PC1}.}

\item{...}{If \code{what = "PC?"}, the user can specify whether to plot the QTS in
the tangent space or in the original space by providing a boolean argument
\code{original_space} which defaults to \code{TRUE}. If \code{what = "scores"}, the user
can specify the plane onto which the individuals will be projected by
providing a length-2 integer vector argument \code{plane} which defaults to
\code{1:2}.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
This function creates a visualization of the results of the PCA applied on a
sample of QTS and returns the corresponding \link[ggplot2:ggplot]{ggplot2::ggplot} object which
enable further customization of the plot.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
df <- as_qts_sample(vespa64$igp[1:16])
res_pca <- prcomp(df)

# Plot the data points in a PC plane
# And color points according to a categorical variable
p <- ggplot2::autoplot(res_pca, what = "scores")
p + ggplot2::geom_point(ggplot2::aes(color = vespa64$V[1:16]))
\dontshow{\}) # examplesIf}
}
