% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.slope}
\alias{ci.slope}
\title{Confidence interval for a slope in a simple linear model}
\usage{
ci.slope(alpha, cor, sdy, sdx, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{estimated Pearson correlation}

\item{sdy}{estimated standard deviation of response variable}

\item{sdx}{estimated standard deviation of predictor variable}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated slope
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population slope coefficient in a
simple linear model using the sample correlation, sample standard
deviation of the y scores (response variable), sample standard deviation
of the x scores (predictor variable), and sample size as input.

For more details, see Section 1.11 of Bonett (2021, Volume 2)
}
\examples{
ci.slope(.05, .362, 25.1, 6.25, 85)

# Should return:
#  Estimate        SE      t df       p        LL       UL
#  1.453792 0.4109165 3.5379 83 0.00066 0.6364957 2.271088
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
