% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.cronbach}
\alias{size.ci.cronbach}
\title{Sample size for a Cronbach reliability confidence interval}
\usage{
size.ci.cronbach(alpha, rel, r, w)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{rel}{reliability planning value}

\item{r}{number of measurements (items, raters, forms)}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a Cronbach reliability
with desired confidence interval precision. Set the reliability planning
value to the smallest value within a plausible range for a
conservatively large sample size.
}
\details{
For more details, see Section 4.26 of Bonett (2021, Volume 1)
}
\examples{
size.ci.cronbach(.05, .75, 5, .15)

# Should return:
# Sample size
#         109
 

}
\references{
\insertRef{Bonett2015}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
