% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.pbcor}
\alias{size.ci.pbcor}
\title{Sample size for a point-biserial correlation confidence interval}
\usage{
size.ci.pbcor(alpha, cor, w, p)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{planning value of point-biserial correlation}

\item{w}{desired confidence interval width}

\item{p}{proportion of members in one of the two subpopulations}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population point-biserial
correlation with desired confidence interval precision in a two-group
nonexperimental design with simple random sampling. A two-group
nonexperimental design implies two subpopulations (e.g., all boys and all
girls in a school district). This function requires a planning value for the
proportion of population members who belong to one of the two subpopulations.
Set the correlation planning value to the smallest absolute value within a
plausible range for a conservatively large sample size.

For more details, see Section 1.24 of Bonett (2021, Volume 2)
}
\examples{
size.ci.pbcor(.05, .40, .25, .73)

# Should return:
# Sample size
#         168
 

}
\references{
\insertRef{Bonett2020a}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
