% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{test.prop2}
\alias{test.prop2}
\title{Hypothesis test for a 2-group proportion difference}
\usage{
test.prop2(f1, f2, n1, n2)
}
\arguments{
\item{f1}{number of group 1 participants who have the attribute}

\item{f2}{number of group 2 participants who have the attribute}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - ML estimate of proportion difference
\item z - z test statistic
\item p - two-sided p-value
}
}
\description{
Computes a continuity-corrected z-test for a difference of population
proportions in a 2-group design. A confidence interval for a difference in
population proportions is a recommended supplement to the z-test (see
\link[statpsych]{ci.prop2}).

For more details, see Section 2.4 of Bonett (2021, Volume 3)
}
\examples{
test.prop2(39, 24, 50, 50)

# Should return:
# Estimate      z       p
#      0.3 2.8997 0.00373


}
\references{
\insertRef{Snedecor1980}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
