% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_effects.R
\name{RandomEffectsTracker}
\alias{RandomEffectsTracker}
\title{Random Effects Tracker C++ Wrapper}
\description{
Class that defines a "tracker" for random effects models, most notably
storing the data indices available in each group for quicker posterior
computation and sampling of random effects terms.
The class stores a mapping from every observation to its group index, a mapping
from group indices to the training sample observations available in that
group, and predictions for each observation.

This class is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rfx_tracker_ptr}}{External pointer to a C++ StochTree::RandomEffectsTracker class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RandomEffectsTracker-new}{\code{RandomEffectsTracker$new()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RandomEffectsTracker-new"></a>}}
\if{latex}{\out{\hypertarget{method-RandomEffectsTracker-new}{}}}
\subsection{Method \code{new()}}{
Create a new RandomEffectsTracker object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RandomEffectsTracker$new(rfx_group_indices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rfx_group_indices}}{Integer indices indicating groups used to define random effects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RandomEffectsTracker} object.
}
}
}
