% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{get_dbh}
\alias{get_dbh}
\title{Extract diameter at breast height from  `LAS` object representing segmented tree.}
\usage{
get_dbh(
  las,
  intensity_threshold = 41000,
  select_n = 10,
  verticality_threshold = 0.9
)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
individually segmented tree}

\item{intensity_threshold}{numeric - filter value for Intensity to help remove vegetation}

\item{select_n}{numeric - number of points selected on every RANSAC iteration.}

\item{verticality_threshold}{numeric - filter value for Verticality threshold to remove
horizontal branches.}
}
\value{
A named numeric vector with element `dbh` (m).
}
\description{
Function to extract diameter at breast height (1.37 m) from LAS object.
Function filters LAS keeping only points with Intensity greater than
specified threshold. Function calculates verticality eigenvalue and filters
based on verticality threshold. Last, diameter is calculated using a
RANSAC cylinder fitting algorithm.
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = clean_las(las)
print(get_dbh(las))
}
