% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{hull_diagnostic_plot}
\alias{hull_diagnostic_plot}
\title{Diagnostic Plot of Crown Convex Hulls}
\usage{
hull_diagnostic_plot(las, res = 0.1)
}
\arguments{
\item{las}{A `LAS` object from the `lidR` package. Must contain a column named `Crown`.}

\item{res}{Numeric. Resolution for voxelization in `voxel_hull_2D()`. Default is 0.1.}
}
\value{
A `ggplot` object displaying convex hulls (dashed) and voxel hulls (filled).
}
\description{
Generates a 2D diagnostic plot to visualize the convex hulls and voxelized hulls
of tree crowns in a LAS point cloud. Useful for checking results of crown segmentation.
}
\details{
The function first filters points marked as crown (`Crown == 1`) and then
computes both the 2D convex hull and a voxelized 2D hull. The resulting plot
overlays the voxel hull in color and the convex hull as a dashed outline.
}
\examples{
library(lidR)
file = system.file('extdata', file='tree_0744.laz', package='tReeTraits')
las <- readLAS(file)
las <- segment_crown(las)  # adds `Crown` column
hull_diagnostic_plot(las)
}
