% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tree.R
\name{get_tsi}
\alias{get_tsi}
\title{get_tsi}
\usage{
get_tsi(filename, extant = TRUE, recname = NULL, verbose = FALSE)
}
\arguments{
\item{filename}{path where files or qs2/rds was exported, reconstruct object of class tabs or recvect object}

\item{extant}{boolean, only for currently existing shapes (TRUE) or all shapes (FALSE)}

\item{recname}{recname, default NULL will create a tree for every merged polygon}

\item{verbose}{boolean, print messages}
}
\value{
list of dendrogram objects
}
\description{
get the time since isolation on a tabs object or recvect object
}
\examples{
\dontrun{
# load data samples
sporades <- sporades()
topo <- sporades$topo
labs <- sporades$labs
curve <- sporades$curve


# change duplicated names 
duplicates <- labs[labs$name == 'UNKNOWN',]$name
labs[labs$name == 'UNKNOWN',]$name <- paste0(duplicates,' ',toupper(letters[1:length(duplicates)]))

# reconstruct
rec <- reconstruct(topo=topo,
                   region=labs,
                   curve=curve,
                   reclabs='name'
                   )

# present day shapes only
tsi_e <- get_tsi(rec,
                 extant=TRUE
                 )
                      
# present and past shapes               
tsi_a <- get_tsi(rec,
                 extant=FALSE
                 )
         
# select specific shape for which the connectivity change is calculated
tsi <- get_tsi(rec,
               recname=rec$recvect$AP0000000$recname[6],
               extant=FALSE)
}
}
\author{
Johannes De Groeve
}
