% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_hook_outer.R, R/tar_hook_outer_raw.R
\name{tar_hook_outer}
\alias{tar_hook_outer}
\alias{tar_hook_outer_raw}
\title{Hook to wrap commands}
\usage{
tar_hook_outer(
  targets,
  hook,
  names = NULL,
  set_deps = TRUE,
  envir = parent.frame()
)

tar_hook_outer_raw(
  targets,
  hook,
  names = NULL,
  set_deps = TRUE,
  envir = parent.frame()
)
}
\arguments{
\item{targets}{A list of target definition objects. The input target list
can be arbitrarily nested, but it must consist entirely of target
objects. In addition, the return value is a simple list
where each element is a target definition object.
All hook functions remove the nested structure of the input target list.}

\item{hook}{R code to wrap each target's command.
The hook must contain the special placeholder symbol \code{.x}
so \code{tar_hook_outer()} knows where to insert the original command
of the target.

\code{tar_hook_outer()} expects unevaluated expressions for the \code{hook} and
\code{names} arguments, whereas \code{tar_hook_outer_raw()} expects
evaluated expression objects.}

\item{names}{Name of targets in the target list
to apply the hook. Supplied using \code{tidyselect} helpers like
\code{\link[=starts_with]{starts_with()}}, as in \code{names = starts_with("your_prefix_")}.
Set to \code{NULL} to include all targets supplied to the \code{targets} argument.
Targets not included in \code{names} still remain in the target list,
but they are not modified because the hook does not apply to them.

The regular hook functions expects unevaluated expressions for the \code{hook}
and \code{names} arguments, whereas the \code{"_raw"} versions expect
evaluated expression objects.}

\item{set_deps}{Logical of length 1, whether to refresh the dependencies
of each modified target by scanning the newly generated
target commands for dependencies. If \code{FALSE}, then the target will
keep the original set of dependencies it had before the hook.
Set to \code{NULL} to include all targets supplied to the \code{targets} argument.
\code{TRUE} is recommended for nearly all situations. Only use \code{FALSE}
if you have a specialized use case and you know what you are doing.}

\item{envir}{Optional environment to construct the quosure for the \code{names}
argument to select names.}
}
\value{
A flattened list of target definition objects with the hooks applied.
Even if the input target list had a nested structure,
the return value is a simple list where each element
is a target definition object.
All hook functions remove the nested structure of the input target list.
}
\description{
Wrap the command of each target in an arbitrary R expression.
\code{tar_hook_outer()} expects unevaluated expressions for the \code{hook} and
\code{names} arguments, whereas \code{tar_hook_outer_raw()} expects
evaluated expression objects.
}
\details{
The expression you supply to \code{hook}
must contain the special placeholder symbol \code{.x}
so \code{tar_hook_outer()} knows where to insert the original command
of the target.
}
\section{Target definition objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target definition objects
or lists of target definition objects.
target definition objects represent
skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target definition
objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target definition objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  targets <- list(
    # Nested target lists work with hooks.
    list(
      targets::tar_target(x1, task1()),
      targets::tar_target(x2, task2(x1))
    ),
    targets::tar_target(x3, task3(x2)),
    targets::tar_target(y1, task4(x3))
  )
  tarchetypes::tar_hook_outer(
    targets = targets,
    hook = postprocess(.x, arg = "value"),
    names = starts_with("x")
  )
})
targets::tar_manifest(fields = command)
# Using tar_hook_outer_raw():
targets::tar_script({
  targets <- list(
    # Nested target lists work with hooks.
    list(
      targets::tar_target(x1, task1()),
      targets::tar_target(x2, task2(x1))
    ),
    targets::tar_target(x3, task3(x2)),
    targets::tar_target(y1, task4(x3))
  )
  tarchetypes::tar_hook_outer_raw(
    targets = targets,
    hook = quote(postprocess(.x, arg = "value")),
    names = quote(starts_with("x"))
  )
})
})
}
}
\seealso{
Other hooks: 
\code{\link{tar_hook_before}()},
\code{\link{tar_hook_inner}()}
}
\concept{hooks}
