% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-access.R
\name{get_soundstat_audio_features}
\alias{get_soundstat_audio_features}
\title{SoundStat audio features}
\usage{
get_soundstat_audio_features(
  track_id,
  convert_values = FALSE,
  api_key = get_soundstat_api_key()
)
}
\arguments{
\item{track_id}{The Spotify ID for a track.}

\item{convert_values}{Logical. For SoundStat features, should audio features
be converted to the Spotify scale. See details for conversion formulas.}

\item{api_key}{A SoundStat API key, e.g., \code{\link[=get_soundstat_api_key]{get_soundstat_api_key()}}.}
}
\value{
A \link[tibble:tibble-package]{tibble} with track audio features,
including:
\itemize{
\item \code{danceability}: Danceability score (0-1).
\item \code{energy}: Energy level (0-1).
\item \code{loudness}: Loudness level (0-1).
\item \code{acousticness}: Acousticness score (0-1).
\item \code{instrumentalness}: Instrumentalness score (0-1).
\item \code{valence}: Mood/positiveness (0-1).
\item \code{tempo}: Track tempo in beats per minute (BPM).
\item \code{key}: Track key (0-11).
\item \code{mode}: Mode (0 - minor, 1 - major).
\item \code{key_name}: Corresponds directly to the key, but the integer is
converted to the key name using Pitch Class notation (e.g., 0 becomes
\code{C}).
\item \code{mode_name}: Corresponds directly to the mode, but the integer is
converted to the mode name (e.g., 0 becomes \code{minor}).
\item \code{key_mode}: A combination of the \code{key_name} and \code{mode_name} variables
(e.g., \verb{C minor}).
}
}
\description{
Access the SoundStat API to get audio features for tracks.
}
\details{
Due to differences in algorithms and methodologies, the SoundStat audio
features are on a slightly different scale than the audio features that were
originally included in \link{taylor} prior to the \href{https://developer.spotify.com/blog/2024-11-27-changes-to-the-web-api}{changes to the Spotify API}.
We can convert the SoundStat values to the Spotify scale using the formulas
in the \href{https://soundstat.info/article/Understanding-Audio-Analysis.html}{SoundStat docs}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{acousticness = sound_value * 0.005
energy = sound_value * 2.25
instrumentalness = sound_value * 0.03
loudness = -(1 - sound_value) * 14
}\if{html}{\out{</div>}}

To automatically perform these conversions, set \code{convert_values = TRUE}.
}
\examples{
\dontshow{if (taylor_examples()) withAutoprint(\{ # examplesIf}
get_soundstat_audio_features(track_id = "7Mts0OfPorF4iwOomvfqn1")
\dontshow{\}) # examplesIf}
}
\seealso{
Other API access: 
\code{\link{get_reccobeats_audio_features}()},
\code{\link{get_spotify_track_info}()}
}
\concept{API access}
