% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{log_posterior_neg}
\alias{log_posterior_neg}
\title{Evaluate the negative log posterior value of a parameter vector}
\usage{
log_posterior_neg(lpars, pkmod, inf, tms, obs)
}
\arguments{
\item{lpars}{Logged parameter values. Can be a subset of the full set of PK or PK-PD parameter values.}

\item{pkmod}{`pkmod` object. Mean values are a subset of log(pars_pk), log(pars_pd),
log(sigma_add), log(sigma_mult). PK-PD parameter values not specified in `lpars` will be inferred from `pkmod`.}

\item{inf}{Infusion schedule}

\item{tms}{Times associated with observations}

\item{obs}{Observed values (concentrations or PD response values)}
}
\value{
Numeric value of length 1
}
\description{
Evaluate the negative log posterior value of a parameter vector given a set of
observations and prior distribution for log-normally distributed PK or PK-PD parameters.
}
\examples{
# evaluate negative log posterior at a new set of parameters
lpars = log(c(cl=11,q2=3,q3=25,v=20,v2=40,v3=80,ke0=1.15,sigma_add=0.3))
prior_vcov <- matrix(diag(c(0.265,0.346,0.209,0.610,0.565,0.597,0.702,0.463)),
8,8, dimnames = list(NULL,names(lpars)))
my_mod <- pkmod(pars_pk = c(cl = 10, q2 = 2, q3 =20, v = 15, v2 = 30, v3 = 50,
ke0 = 1.2), sigma_add = 0.2, log_response = TRUE, Omega = prior_vcov)
inf <- inf_manual(inf_tms = 0, inf_rate = 80, duration = 2)
tms <- c(1,2,4,8,12)
obs <- simulate(my_mod, inf = inf, tms = tms)
log_posterior_neg(lpars, my_mod, inf, tms, obs)

# evaluate log-prior for subset of parameters (remove volume parameters)
lpars_sub = log(c(cl=11,q2=3,q3=25,ke0=1.15,sigma_add=0.15))
my_mod <- update(my_mod, Omega = matrix(diag(c(0.265,0.346,0.209,0.702,0.463)),
5,5, dimnames = list(NULL,names(lpars_sub))))
log_posterior_neg(lpars_sub, my_mod, inf, tms, obs)

# add a pd response and replace multiplicative error with additive error
# evaluate likelihood at new parameters
lpars_pd_eval = log(c(cl=11,q3=25,v=15,ke0=1.15,sigma_add=4,c50=5,gamma=1))
prior_vcov_pd <- matrix(diag(c(0.265,0.209,0.610,0.702,0.230,0.242,0.1)),7,7,
dimnames = list(NULL,names(lpars_pd_eval)))
my_mod_pd <- update(my_mod, pars_pd = c(c50 = 2.8, gamma = 1.47, e0 = 93, emx = 93),
pdfn = emax, pdinv = emax_inv, ecmpt = 4, sigma_mult = 0, sigma_add = 4,
Omega = prior_vcov_pd)
# simulate observations
obs_pd <- simulate(my_mod_pd, inf = inf, tms = seq(0,12,0.5))
log_posterior_neg(lpars_pd_eval, my_mod_pd, inf, tms, obs_pd)
}
