% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_card.R
\name{teal_card}
\alias{teal_card}
\alias{teal_card<-}
\alias{as.teal_card}
\alias{c.teal_card}
\alias{[.teal_card}
\title{\code{teal_card}: An \code{S3} class for managing \code{teal} reports}
\usage{
teal_card(...)

teal_card(x) <- value

as.teal_card(x)

\method{c}{teal_card}(...)

\method{[}{teal_card}(x, i)
}
\arguments{
\item{...}{Elements from which \code{teal_card} will be combined.}

\item{x}{Object to convert to teal_card}

\item{value}{(\code{teal_card}) object to set in the \code{teal_report}.}

\item{i}{index specifying elements to extract or replace}
}
\value{
An \code{S3} \code{list} of class \code{teal_card}.

A teal_card object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{teal_card} \code{S3} class provides functionality to store, manage, edit, and adjust report contents.
It enables users to create, manipulate, and serialize report-related data efficiently.

The \code{teal_card()} function serves two purposes:
\enumerate{
\item When called with a \code{teal_report} object, it acts as a getter and returns the card slot.
\item When called with other arguments, it creates a new \code{teal_card} object from those arguments.
}

This function ensures that input is converted to a teal_card object.
It accepts various input types and converts them appropriately.
}
\details{
The \code{teal_card} class supports \code{c()} and \code{x[i]} methods for combining and subsetting elements.
However, these methods only function correctly when the first element is a \code{teal_card}.
}
\examples{
# create an empty card
report <- teal_card()

# Create a card with content
report <- teal_card(
  "## Headline",
  "This is `iris` table",
  code_chunk("print(iris)", lang = "R"),
  iris
)

# Add elements to the report
report <- c(
  report,
  list("## mtcars Table"),
  code_chunk("print(mtcars)", lang = "R"),
  mtcars
)

# Subset the report to keep only the first two elements
report[1:2]

# Replace element
report[[1]] <- "## Iris Table"

# Append element
report <- append(report, teal_card("# Awesome Report"), after = 0)
tools::toHTML(report)

if (interactive()) {
  render(report, output_format = rmarkdown::pdf_document())
}

}
\seealso{
\code{\link[=code_chunk]{code_chunk()}}, \code{\link[=render]{render()}}, \code{\link[=toHTML]{toHTML()}}
}
