% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_rmd.R
\name{to_rmd}
\alias{to_rmd}
\title{Convert \code{ReporterCard}/\code{teal_card} content to \code{rmarkdown}}
\usage{
to_rmd(block, ...)
}
\arguments{
\item{block}{(\code{any}) content which can be represented in Rmarkdown syntax.}

\item{...}{additional arguments passed to implemented methods for different classes.}
}
\value{
\code{character(1)} containing a content or Rmarkdown document.
}
\description{
This is an S3 generic that is used to generate content in \code{rmarkdown} format
from various types of blocks in a \code{ReporterCard} or \code{teal_card} object.
}
\details{
\subsection{Customize \code{to_rmd}}{

The methods for this S3 generic can be extended by the app developer or even overwritten.
For this a function with the name \verb{to_rmd.<class>} should be defined in the
Global Environment or registered as an S3 method, where \verb{<class>} is the class of the
object to be converted.

For example, to override the default behavior for \code{code_chunk} class, you can use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{to_rmd.code_chunk <- function(block, ...) \{
  # custom implementation
  sprintf("### A custom code chunk\\n\\n```\{r\}\\n\%s\\n```\\n", block)
\}
}\if{html}{\out{</div>}}

Alternatively, the S3 method can be registered using \code{registerS3method("to_rmd", "<class>", fun)}
}

\subsection{Defaults}{

\code{teal.reporter} provides default \code{to_rmd} methods for several common classes that
returns the content in appropriate R Markdown syntax.
These include:
\itemize{
\item \code{character}
\item \code{\link[=code_chunk]{code_chunk()}} objects
\item \code{ggplot2} plots
\item \code{data.frame}
\item \code{flextable}
\item \code{rtables} tables
\item and others.
}

All of these defaults can be overridden by defining new \verb{to_rmd.<class>} methods.
These methods are implemented internally using the helper function \verb{.to_rmd.<class>}.
}
}
\examples{
to_rmd(c("## This is a simple text block.", "", "With a paragraph break."))
to_rmd(code_chunk("summary(cars)"))
to_rmd(data.frame(x = 1:10, y = 21:30), folder_path = tempdir())
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}

# Example with ggplot2 will create a temporary RDS file in the tempdir()
to_rmd(
  ggplot2::ggplot(mtcars, ggplot2::aes(x = wt, y = mpg)) +
    ggplot2::geom_point(),
  folder_path = tempdir() # internal argument of ggplot2 method
)
\dontshow{\}) # examplesIf}
}
