% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sixel.R
\name{sixel}
\alias{sixel}
\title{Terminal Graphics Protocol Device}
\usage{
sixel(
  width = getOption("term_width", max(480, min(1200, term_width(), term_height()/0.8))),
  height = getOption("term_height", 0.8 * width),
  units = "px",
  res = getOption("term_res", NA),
  ...,
  term_col = getOption("term_col", FALSE),
  term_bg = term_col,
  term_fg = term_col
)
}
\arguments{
\item{width}{The width of the image. Passed on to
\code{\link[ragg]{agg_capture}}.}

\item{height}{The height of the image. Passed on to
\code{\link[ragg]{agg_capture}}.}

\item{units}{The units in which 'height' and 'width' are given. Passed on to
\code{\link[ragg]{agg_capture}}.}

\item{res}{The resolution of the image. Passed on to
\code{\link[ragg]{agg_capture}}.}

\item{...}{passed on to the underlying \code{\link[ragg]{agg_capture}}
device.}

\item{term_col}{Logical value indicating that the foreground and background
colors used in the plot should be set to that of the terminal.}

\item{term_bg}{Logical value indicating that the background color used in
the plot should be set to that of the terminal.}

\item{term_fg}{Logical value indicating that the foreground color used in
the plot should be set to that of the terminal.}
}
\value{
\code{sixel} is called for its side effect of opening a graphics device.
Invisibly returns an list with two functions: \code{plot} will plot the
current contents of the device in the terminal and \code{update} will plot
the current contents of the device in the terminal if the contents have
changed since the last plot.

\code{\link{term_replot}} will redraw the content of the device in the
terminal. In principle \code{\link{term_replot}} is called automatically
when the contents of the device changed. This function can be used to force
plotting. 

When \code{term_bg = TRUE} the background color of the graphics device
('\code{bg}') will be set using \code{\link[graphics]{par}}. When
\code{term_fg = TRUE} the foreground color ('\code{fg}', '\code{col}',
'\code{col.axis}', '\code{col.lab}', '\code{col.main}', and '\code{sub}')
will be set using \code{\link[graphics]{par}}.
}
\description{
Terminal Graphics Protocol Device
}
\details{
The function tries to detect whether the terminal supports Sixel. If not, it
will issue a warning but still output the image to the terminal. Terminals
that to not support Sixel will ignore the output. The warning is shown only
once. Please file an issue when the terminal does support Sixel while
\code{\link{has_sixel_support}} returns \code{FALSE}. The warning can be
disabled using \code{options(warned_sixel_support = TRUE)}.
}
\examples{
if (has_sixel_support()) {
  # Open device
  sixel()
  plot(rnorm(100))
  abline(h = 0, lwd = 2, col = term_palette()[1])
}

}
