% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-test.R
\name{auto_test}
\alias{auto_test}
\alias{auto_test_package}
\title{Watches code and tests for changes, rerunning tests as appropriate.}
\usage{
auto_test(
  code_path,
  test_path,
  reporter = default_reporter(),
  env = test_env(),
  hash = TRUE
)

auto_test_package(pkg = ".", reporter = default_reporter(), hash = TRUE)
}
\arguments{
\item{code_path}{path to directory containing code}

\item{test_path}{path to directory containing tests}

\item{reporter}{test reporter to use}

\item{env}{environment in which to execute test suite.}

\item{hash}{Passed on to \code{\link[=watch]{watch()}}.  When FALSE, uses less accurate
modification time stamps, but those are faster for large files.}

\item{pkg}{path to package}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

The idea behind \code{auto_test()} is that you just leave it running while
you develop your code.  Every time you save a file it will be automatically
tested and you can easily see if your changes have caused any test
failures.

The current strategy for rerunning tests is as follows:
\itemize{
\item if any code has changed, then those files are reloaded and all tests
rerun
\item otherwise, each new or modified test is run
}
}
\seealso{
\code{\link[=auto_test_package]{auto_test_package()}}
}
\keyword{internal}
