% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-shape.R
\name{expect_length}
\alias{expect_length}
\alias{expect_shape}
\title{Do you expect an object with this length or shape?}
\usage{
expect_length(object, n)

expect_shape(object, ..., nrow, ncol, dim)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{n}{Expected length.}

\item{...}{Not used; used to force naming of other arguments.}

\item{nrow, ncol}{Expected \code{\link[=nrow]{nrow()}}/\code{\link[=ncol]{ncol()}} of \code{object}.}

\item{dim}{Expected \code{\link[=dim]{dim()}} of \code{object}.}
}
\description{
\code{expect_length()} inspects the \code{\link[=length]{length()}} of an object; \code{expect_shape()}
inspects the "shape" (i.e. \code{\link[=nrow]{nrow()}}, \code{\link[=ncol]{ncol()}}, or \code{\link[=dim]{dim()}}) of
higher-dimensional objects like data.frames, matrices, and arrays.
}
\examples{
expect_length(1, 1)
expect_length(1:10, 10)
show_failure(expect_length(1:10, 1))

x <- matrix(1:9, nrow = 3)
expect_shape(x, nrow = 3)
show_failure(expect_shape(x, nrow = 4))
expect_shape(x, ncol = 3)
show_failure(expect_shape(x, ncol = 4))
expect_shape(x, dim = c(3, 3))
show_failure(expect_shape(x, dim = c(3, 4, 5)))
}
\seealso{
\code{\link[=expect_vector]{expect_vector()}} to make assertions about the "size" of a vector.

Other expectations: 
\code{\link{comparison-expectations}},
\code{\link{equality-expectations}},
\code{\link{expect_error}()},
\code{\link{expect_match}()},
\code{\link{expect_named}()},
\code{\link{expect_null}()},
\code{\link{expect_output}()},
\code{\link{expect_reference}()},
\code{\link{expect_silent}()},
\code{\link{inheritance-expectations}},
\code{\link{logical-expectations}}
}
\concept{expectations}
