% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_urls.R
\name{fetch_urls}
\alias{fetch_urls}
\title{Fetch URLs from a search engine}
\usage{
fetch_urls(query, n_pages = 1, date_filter = "w")
}
\arguments{
\item{query}{Search query string.}

\item{n_pages}{Number of DDG Lite pages to fetch (default 1). ~30 results per page.}

\item{date_filter}{Recency filter: \code{"d"} (day), \code{"w"} (week), \code{"m"} (month), or \code{"none"} (default \code{"w"}).}
}
\value{
A \code{data.table} with columns \code{search_engine}, \code{url}, \code{is_excluded}.
}
\description{
Queries DuckDuckGo Lite and returns result URLs (no local text search).
Use \code{\link{read_urls}} to get content from these URLs.
}
\examples{
\dontrun{
urls_dt <- fetch_urls("R programming nlp", n_pages = 1)
urls_dt$url
}
}
