% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_fair_theory.R
\name{create_fair_theory}
\alias{create_fair_theory}
\title{Create FAIR Theory Repository}
\usage{
create_fair_theory(
  path,
  title = NULL,
  theory_file = NULL,
  remote_repo = NULL,
  add_license = "cc0",
  ...
)
}
\arguments{
\item{path}{Character, indicating the directory in which to create the FAIR
theory.}

\item{title}{Character, indicating the theory title. Default: \code{NULL}}

\item{theory_file}{Character, referring to existing theory file(s) to be
copied, or a new theory file to be created. Default \code{NULL} does nothing.}

\item{remote_repo}{Name of a 'GitHub' repository that exists or should be
created on the current authenticated user's account, see
\code{\link[gh]{gh_whoami}}, Default: NULL}

\item{add_license}{PARAM_DESCRIPTION, Default: 'cc0'}

\item{...}{Additional arguments passed to other functions.}
}
\value{
Invisibly returns a logical value,
indicating whether the function was successful or not.
}
\description{
Partly automates the process of creating a FAIR theory
repository, see Details.
}
\details{
The following steps are executed sequentially:
\enumerate{
\item Create a project folder at \code{path}
\item Initialize a local 'Git' repository at \code{path}
\item If \code{remote_repo} refers to a user's existing 'GitHub' repository, add it
as remote to the local 'Git' repository. Otherwise, create a new 'GitHub'
repository by that name and add it as remote.
\item Add theory file. If \code{theory_file} refers to an existing file, copy it to
\code{path}. If \code{theory_file} refers to a new file, create it in \code{path}.
\item Add the license named by \code{add_license}
\item Add a README.md file
\item Add 'Zenodo' metadata so that it recognizes the repository as a FAIR
theory
\item If it is possible to push to the remote repository, use
\code{\link[worcs]{git_update}} to push the repository to 'GitHub'
}
}
\examples{
# Create a theory with no remote repository (for safe testing)
theory_dir <- file.path(tempdir(), "theory")
create_fair_theory(path = theory_dir,
                   title = "This is My Theory",
                   theory_file = "theory.txt",
                   remote_repo = NULL,
                   add_license = "cc0")

# Create a theory with a remote repository
\dontrun{
theory_dir <- file.path(tempdir(), "theory_github")
out <- create_fair_theory(path = theory_dir,
                          title = "This is My GitHub Theory",
                          theory_file = "theory.txt",
                          remote_repo = "delete_test",
                          add_license = "ccby")
}
}
\seealso{
\code{\link[gert]{git_repo}}
\code{\link[worcs]{add_license_file}}, \code{\link[worcs]{git_update}}
}
