% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string-cleaning.R
\name{audit_transform}
\alias{audit_transform}
\alias{print.audit_transform}
\title{Audit a String Transformation}
\usage{
audit_transform(x, clean_fn, name = NULL)

\method{print}{audit_transform}(x, ...)
}
\arguments{
\item{x}{Character vector to transform.}

\item{clean_fn}{A function that takes a character vector and returns a
transformed character vector of the same length.}

\item{name}{Optional name for the variable (used in output). If \code{NULL},
captures the variable name from the call.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An S3 object of class \code{audit_transform} containing:
\describe{
\item{name}{Name of the variable}
\item{clean_fn_name}{Name of the transformation function used}
\item{n_total}{Total number of elements}
\item{n_changed}{Count of values that changed}
\item{n_unchanged}{Count of values that stayed the same}
\item{n_na}{Count of NA values}
\item{pct_changed}{Percentage of non-NA values that changed}
\item{change_examples}{Data.frame with before/after pairs}
\item{cleaned}{The transformed character vector}
}
}
\description{
Applies a transformation function to a character vector and reports what
changed. Provides transparency about the transformation by showing counts
and before/after examples.
}
\examples{
x <- c("  hello ", "WORLD", "  foo  ", NA)
result <- audit_transform(x, trimws)
result$cleaned

}
\seealso{
Other data quality: 
\code{\link{diagnose_nas}()},
\code{\link{diagnose_strings}()},
\code{\link{get_summary_table}()},
\code{\link{summarize_column}()}
}
\concept{data quality}
