% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-keys.R
\name{validate_primary_keys}
\alias{validate_primary_keys}
\alias{print.validate_pk}
\title{Validate Primary Keys}
\usage{
validate_primary_keys(.data, keys)

\method{print}{validate_pk}(x, ...)
}
\arguments{
\item{.data}{A data.frame or tibble.}

\item{keys}{Character vector of column names to test as primary keys.}

\item{x}{An object to print.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An S3 object of class \code{validate_pk} containing:
\describe{
\item{table_name}{Name of the input table from the original call}
\item{keys}{Character vector of column names tested}
\item{is_primary_key}{Logical: TRUE if keys uniquely identify all rows AND
no key column contains NA values}
\item{n_rows}{Total number of rows in the table}
\item{n_unique_keys}{Number of distinct key combinations}
\item{n_duplicate_keys}{Number of key combinations that appear more than once}
\item{duplicate_keys}{A data.frame of duplicated key values with their counts}
\item{has_numeric_keys}{Logical: TRUE if any key column is of type double}
\item{has_na_keys}{Logical: TRUE if any key column contains NA values}
\item{na_in_keys}{Named logical vector indicating which key columns contain NAs}
}
}
\description{
Tests whether a set of columns constitute primary keys of a data.frame,
i.e., whether they uniquely identify every row in the table.
}
\examples{
df <- data.frame(
  id = c(1L, 2L, 3L, 4L),
  group = c("A", "A", "B", "B"),
  value = c(10, 20, 30, 40)
)
validate_primary_keys(df, "id")
validate_primary_keys(df, "group")

}
\seealso{
Other join validation: 
\code{\link{compare_tables}()},
\code{\link{validate_join}()},
\code{\link{validate_var_relationship}()}
}
\concept{join validation}
