% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_impute_simple.R
\name{gt_impute_simple}
\alias{gt_impute_simple}
\title{Simple imputation based on allele frequencies}
\usage{
gt_impute_simple(x, method = c("mode", "mean0", "random"), n_cores = 1)
}
\arguments{
\item{x}{a \link{gen_tibble} with missing data}

\item{method}{one of
\itemize{
\item 'mode': the most frequent genotype
\item 'mean0': the mean rounded to the nearest integer
\item 'random': randomly sample a genotype based on the observed
allele frequencies
}}

\item{n_cores}{the number of cores to be used}
}
\value{
a \link{gen_tibble} with imputed genotypes
}
\description{
This function provides a very simple imputation algorithm for \code{gen_tibble}
objects by using the mode, mean or sampling from the allele frequencies. Each
locus is imputed independently (and thus linkage information is ignored).
}
\details{
This function is a wrapper around \code{\link[bigsnpr:snp_fastImputeSimple]{bigsnpr::snp_fastImputeSimple()}}.
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) withAutoprint(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("gen_tbl")

# Impute the gen_tibble
example_gt <- example_gt \%>\% gt_impute_simple()

# And we can check it has been imputed
example_gt \%>\% gt_has_imputed()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[bigsnpr:snp_fastImputeSimple]{bigsnpr::snp_fastImputeSimple()}} which this function wraps.
}
